/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.services.MigrationContextImpl;
import com.hedera.node.app.services.MigrationStateChanges;
import com.hedera.node.app.state.merkle.SchemaApplicationType;
import com.hedera.node.app.state.merkle.SchemaApplications;
import com.hedera.node.app.state.merkle.VersionUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.StartupNetworks;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.spi.FilteredReadableStates;
import com.swirlds.state.spi.FilteredWritableStates;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.constructable.ConstructableRegistry;

public class MerkleSchemaRegistry
implements SchemaRegistry {
    private static final Logger logger = LogManager.getLogger(MerkleSchemaRegistry.class);
    private final String serviceName;
    private final Configuration bootstrapConfig;
    private final ConstructableRegistry constructableRegistry;
    private final SortedSet<Schema> schemas = new TreeSet<Schema>();
    private final SchemaApplications schemaApplications;

    public MerkleSchemaRegistry(@NonNull ConstructableRegistry constructableRegistry, @NonNull String serviceName, @NonNull Configuration bootstrapConfig, @NonNull SchemaApplications schemaApplications) {
        this.constructableRegistry = Objects.requireNonNull(constructableRegistry);
        this.serviceName = StateMetadata.validateStateKey((String)Objects.requireNonNull(serviceName));
        this.bootstrapConfig = Objects.requireNonNull(bootstrapConfig);
        this.schemaApplications = Objects.requireNonNull(schemaApplications);
    }

    public SchemaRegistry register(@NonNull Schema schema) {
        this.schemas.remove(schema);
        this.schemas.add(Objects.requireNonNull(schema));
        logger.debug("Registering schema {} for service {} ", new Supplier[]{() -> HapiUtils.toString((SemanticVersion)schema.getVersion()), () -> this.serviceName});
        schema.statesToCreate(this.bootstrapConfig).forEach(def -> {
            StateMetadata md = new StateMetadata(this.serviceName, schema, def);
            StateUtils.registerWithSystem((StateMetadata)md, (ConstructableRegistry)this.constructableRegistry);
        });
        return this;
    }

    public void migrate(@NonNull MerkleNodeState stateRoot, @Nullable SemanticVersion previousVersion, @NonNull SemanticVersion currentVersion, @NonNull Configuration appConfig, @NonNull Configuration platformConfig, @NonNull Map<String, Object> sharedValues, @NonNull MigrationStateChanges migrationStateChanges, @NonNull StartupNetworks startupNetworks, @NonNull PlatformStateFacade platformStateFacade) {
        Objects.requireNonNull(stateRoot);
        Objects.requireNonNull(currentVersion);
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(platformConfig);
        Objects.requireNonNull(sharedValues);
        Objects.requireNonNull(migrationStateChanges);
        if (VersionUtils.isSoOrdered(currentVersion, previousVersion)) {
            throw new IllegalArgumentException("The currentVersion must be at least the previousVersion");
        }
        long roundNumber = platformStateFacade.roundOf((State)stateRoot);
        if (this.schemas.isEmpty()) {
            logger.info("Service {} does not use state", (Object)this.serviceName);
            return;
        }
        SemanticVersion latestVersion = this.schemas.getLast().getVersion();
        Supplier[] supplierArray = new Supplier[5];
        supplierArray[0] = this.schemas::size;
        supplierArray[1] = () -> this.serviceName;
        supplierArray[2] = () -> HapiUtils.toString((SemanticVersion)previousVersion);
        supplierArray[3] = () -> HapiUtils.toString((SemanticVersion)currentVersion);
        supplierArray[4] = () -> HapiUtils.toString((SemanticVersion)latestVersion);
        logger.info("Applying {} schemas for service {} with state version {}, software version {}, and latest service schema version {}", supplierArray);
        for (Schema schema : this.schemas) {
            WritableStates newStates;
            WritableStates writableStates;
            Set<SchemaApplicationType> applications = this.schemaApplications.computeApplications(previousVersion, latestVersion, schema, appConfig);
            logger.info("Applying {} schema {} ({})", (Object)this.serviceName, (Object)schema.getVersion(), applications);
            ReadableStates readableStates = stateRoot.getReadableStates(this.serviceName);
            FilteredReadableStates previousStates = new FilteredReadableStates(readableStates, readableStates.stateKeys());
            if (applications.contains((Object)SchemaApplicationType.STATE_DEFINITIONS)) {
                List<Schema> schemasAlreadyInState = this.schemas.tailSet(schema).stream().filter(s -> s != schema && previousVersion != null && VersionUtils.alreadyIncludesStateDefs(previousVersion, s.getVersion())).toList();
                RedefinedWritableStates redefinedWritableStates = this.applyStateDefinitions(schema, schemasAlreadyInState, appConfig, stateRoot);
                writableStates = redefinedWritableStates.beforeStates();
                newStates = redefinedWritableStates.afterStates();
            } else {
                newStates = writableStates = stateRoot.getWritableStates(this.serviceName);
            }
            MigrationContextImpl migrationContext = new MigrationContextImpl((ReadableStates)previousStates, newStates, appConfig, platformConfig, previousVersion, roundNumber, sharedValues, startupNetworks);
            if (applications.contains((Object)SchemaApplicationType.MIGRATION)) {
                schema.migrate((MigrationContext)migrationContext);
            }
            if (applications.contains((Object)SchemaApplicationType.RESTART)) {
                schema.restart((MigrationContext)migrationContext);
            }
            if (writableStates instanceof VirtualMapState.MerkleWritableStates) {
                VirtualMapState.MerkleWritableStates mws = (VirtualMapState.MerkleWritableStates)writableStates;
                mws.commit();
                migrationStateChanges.trackCommit();
            }
            schema.statesToRemove().forEach(stateKey -> stateRoot.removeServiceState(this.serviceName, stateKey));
        }
    }

    private RedefinedWritableStates applyStateDefinitions(@NonNull Schema schema, @NonNull List<Schema> schemasAlreadyInState, @NonNull Configuration nodeConfiguration, @NonNull MerkleNodeState stateRoot) {
        schema.statesToCreate(nodeConfiguration).stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> {
            String stateKey = def.stateKey();
            if (schemasAlreadyInState.stream().anyMatch(s -> s.statesToRemove().contains(stateKey))) {
                logger.info("  Skipping {} as it is removed by a later schema", (Object)stateKey);
                return;
            }
            logger.info("  Ensuring {} has state {}", (Object)this.serviceName, (Object)stateKey);
            StateMetadata md = new StateMetadata(this.serviceName, schema, def);
            stateRoot.initializeState(md);
        });
        Set statesToRemove = schema.statesToRemove();
        WritableStates writableStates = stateRoot.getWritableStates(this.serviceName);
        HashSet remainingStates = new HashSet(writableStates.stateKeys());
        remainingStates.removeAll(statesToRemove);
        logger.info("  Removing states {} from service {}", (Object)statesToRemove, (Object)this.serviceName);
        FilteredWritableStates newStates = new FilteredWritableStates(writableStates, remainingStates);
        return new RedefinedWritableStates(writableStates, (WritableStates)newStates);
    }

    private record RedefinedWritableStates(WritableStates beforeStates, WritableStates afterStates) {
    }
}

