/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.tss.codec;

import com.hedera.hapi.node.state.tss.TssEncryptionKeys;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class TssEncryptionKeysJsonCodec
implements JsonCodec<TssEncryptionKeys> {
    @NonNull
    public TssEncryptionKeys parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_current_encryption_key = Bytes.EMPTY;
            Bytes temp_next_encryption_key = Bytes.EMPTY;
            block10: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "currentEncryptionKey": {
                        temp_current_encryption_key = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block10;
                    }
                    case "nextEncryptionKey": {
                        temp_next_encryption_key = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block10;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new TssEncryptionKeys(temp_current_encryption_key, temp_next_encryption_key);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull TssEncryptionKeys data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.currentEncryptionKey() != Bytes.EMPTY && data.currentEncryptionKey() != null && data.currentEncryptionKey().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"currentEncryptionKey", (Bytes)data.currentEncryptionKey()));
        }
        if (data.nextEncryptionKey() != Bytes.EMPTY && data.nextEncryptionKey() != null && data.nextEncryptionKey().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"nextEncryptionKey", (Bytes)data.nextEncryptionKey()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

