/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TokenCreateTransactionBodyJsonCodec
implements JsonCodec<TokenCreateTransactionBody> {
    @NonNull
    public TokenCreateTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            String temp_name = "";
            String temp_symbol = "";
            int temp_decimals = 0;
            long temp_initialSupply = 0L;
            AccountID temp_treasury = null;
            Key temp_adminKey = null;
            Key temp_kycKey = null;
            Key temp_freezeKey = null;
            Key temp_wipeKey = null;
            Key temp_supplyKey = null;
            boolean temp_freezeDefault = false;
            Timestamp temp_expiry = null;
            AccountID temp_autoRenewAccount = null;
            Duration temp_autoRenewPeriod = null;
            String temp_memo = "";
            TokenType temp_tokenType = TokenType.fromProtobufOrdinal(0);
            TokenSupplyType temp_supplyType = TokenSupplyType.fromProtobufOrdinal(0);
            long temp_maxSupply = 0L;
            Key temp_fee_schedule_key = null;
            List temp_custom_fees = Collections.emptyList();
            Key temp_pause_key = null;
            Bytes temp_metadata = Bytes.EMPTY;
            Key temp_metadata_key = null;
            block52: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "name": {
                        temp_name = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block52;
                    }
                    case "symbol": {
                        temp_symbol = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block52;
                    }
                    case "decimals": {
                        temp_decimals = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block52;
                    }
                    case "initialSupply": {
                        temp_initialSupply = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block52;
                    }
                    case "treasury": {
                        temp_treasury = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "adminKey": {
                        temp_adminKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "kycKey": {
                        temp_kycKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "freezeKey": {
                        temp_freezeKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "wipeKey": {
                        temp_wipeKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "supplyKey": {
                        temp_supplyKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "freezeDefault": {
                        temp_freezeDefault = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block52;
                    }
                    case "expiry": {
                        temp_expiry = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "autoRenewAccount": {
                        temp_autoRenewAccount = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "autoRenewPeriod": {
                        temp_autoRenewPeriod = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block52;
                    }
                    case "tokenType": {
                        temp_tokenType = TokenType.fromString(kvPair.value().STRING().getText());
                        continue block52;
                    }
                    case "supplyType": {
                        temp_supplyType = TokenSupplyType.fromString(kvPair.value().STRING().getText());
                        continue block52;
                    }
                    case "maxSupply": {
                        temp_maxSupply = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block52;
                    }
                    case "feeScheduleKey": {
                        temp_fee_schedule_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "customFees": {
                        temp_custom_fees = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), CustomFee.JSON, (int)(maxDepth - 1));
                        continue block52;
                    }
                    case "pauseKey": {
                        temp_pause_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                    case "metadata": {
                        temp_metadata = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block52;
                    }
                    case "metadataKey": {
                        temp_metadata_key = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block52;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new TokenCreateTransactionBody(temp_name, temp_symbol, temp_decimals, temp_initialSupply, temp_treasury, temp_adminKey, temp_kycKey, temp_freezeKey, temp_wipeKey, temp_supplyKey, temp_freezeDefault, temp_expiry, temp_autoRenewAccount, temp_autoRenewPeriod, temp_memo, temp_tokenType, temp_supplyType, temp_maxSupply, temp_fee_schedule_key, temp_custom_fees, temp_pause_key, temp_metadata, temp_metadata_key);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull TokenCreateTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.name() != "") {
            fieldLines.add(JsonTools.field((String)"name", (String)data.name()));
        }
        if (data.symbol() != "") {
            fieldLines.add(JsonTools.field((String)"symbol", (String)data.symbol()));
        }
        if (data.decimals() != 0) {
            fieldLines.add(JsonTools.field((String)"decimals", (int)data.decimals()));
        }
        if (data.initialSupply() != 0L) {
            fieldLines.add(JsonTools.field((String)"initialSupply", (long)data.initialSupply()));
        }
        if (data.treasury() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"treasury", AccountID.JSON, (Object)data.treasury()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.kycKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"kycKey", Key.JSON, (Object)data.kycKey()));
        }
        if (data.freezeKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"freezeKey", Key.JSON, (Object)data.freezeKey()));
        }
        if (data.wipeKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"wipeKey", Key.JSON, (Object)data.wipeKey()));
        }
        if (data.supplyKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"supplyKey", Key.JSON, (Object)data.supplyKey()));
        }
        if (data.freezeDefault()) {
            fieldLines.add(JsonTools.field((String)"freezeDefault", (boolean)data.freezeDefault()));
        }
        if (data.expiry() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"expiry", Timestamp.JSON, (Object)data.expiry()));
        }
        if (data.autoRenewAccount() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccount", AccountID.JSON, (Object)data.autoRenewAccount()));
        }
        if (data.autoRenewPeriod() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewPeriod", Duration.JSON, (Object)data.autoRenewPeriod()));
        }
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.tokenType() != TokenType.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"tokenType", (String)data.tokenType().protoName()));
        }
        if (data.supplyType() != TokenSupplyType.fromProtobufOrdinal(0)) {
            fieldLines.add(JsonTools.field((String)"supplyType", (String)data.supplyType().protoName()));
        }
        if (data.maxSupply() != 0L) {
            fieldLines.add(JsonTools.field((String)"maxSupply", (long)data.maxSupply()));
        }
        if (data.feeScheduleKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"feeScheduleKey", Key.JSON, (Object)data.feeScheduleKey()));
        }
        if (!data.customFees().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"customFees", CustomFee.JSON, data.customFees()));
        }
        if (data.pauseKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"pauseKey", Key.JSON, (Object)data.pauseKey()));
        }
        if (data.metadata() != Bytes.EMPTY && data.metadata() != null && data.metadata().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"metadata", (Bytes)data.metadata()));
        }
        if (data.metadataKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"metadataKey", Key.JSON, (Object)data.metadataKey()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

