/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.cryptography.rpm;

import com.hedera.common.nativesupport.SingletonLoader;
import com.hedera.cryptography.hints.HintsLibraryBridge;
import com.hedera.cryptography.rpm.ProvingAndVerifyingSnarkKeys;
import com.hedera.cryptography.rpm.SigningAndVerifyingSchnorrKeys;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class HistoryLibraryBridge {
    private static final SingletonLoader<HistoryLibraryBridge> INSTANCE_HOLDER = new SingletonLoader("raps", (Object)new HistoryLibraryBridge());

    private HistoryLibraryBridge() {
    }

    public static HistoryLibraryBridge getInstance() {
        return (HistoryLibraryBridge)INSTANCE_HOLDER.getInstance();
    }

    public static byte[] loadAddressBookRotationProgram() throws IOException {
        try (InputStream is = HistoryLibraryBridge.class.getResourceAsStream("/ab-rotation-program");){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[409600];
                while ((bytesRead = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] loadRapsCompressionProgram() throws IOException {
        try (InputStream is = HistoryLibraryBridge.class.getResourceAsStream("/raps-compression-program");){
            byte[] byArray;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int bytesRead;
                byte[] buffer = new byte[409600];
                while ((bytesRead = is.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public native ProvingAndVerifyingSnarkKeys snarkVerificationKey(byte[] var1);

    public native SigningAndVerifyingSchnorrKeys newSchnorrKeyPair(byte[] var1);

    public static byte[] formatRotationMessage(byte[] nextAddressBookHash, byte[] hintsVerificationKeyHash) {
        byte[] arr = new byte[nextAddressBookHash.length + hintsVerificationKeyHash.length];
        System.arraycopy(nextAddressBookHash, 0, arr, 0, nextAddressBookHash.length);
        System.arraycopy(hintsVerificationKeyHash, 0, arr, nextAddressBookHash.length, hintsVerificationKeyHash.length);
        return arr;
    }

    public native byte[] signSchnorr(byte[] var1, byte[] var2);

    public native boolean verifySchnorr(byte[] var1, byte[] var2, byte[] var3);

    public byte[] hashAddressBook(byte[][] verifyingKeys, long[] weights) {
        if (verifyingKeys == null || weights == null || verifyingKeys.length != weights.length || !HintsLibraryBridge.validateWeightsSum((long[])weights)) {
            return null;
        }
        return this.hashAddressBookImpl(verifyingKeys, weights);
    }

    private native byte[] hashAddressBookImpl(byte[][] var1, long[] var2);

    public native byte[] hashHintsVerificationKey(byte[] var1);

    public byte[] proveChainOfTrust(byte[] snarkProvingKey, byte[] snarkVerifyingKey, byte[] genesisAddressBookHash, byte[][] currentAddressBookVerifyingKeys, long[] currentAddressBookWeights, byte[][] nextAddressBookVerifyingKeys, long[] nextAddressBookWeights, byte[] currentAddressBookProof, byte[] nextAddressBookHintsVerificationKeyHash, byte[][] signatures) {
        if (snarkProvingKey == null || snarkProvingKey.length == 0 || genesisAddressBookHash == null || genesisAddressBookHash.length == 0 || currentAddressBookVerifyingKeys == null || currentAddressBookVerifyingKeys.length == 0 || currentAddressBookWeights == null || currentAddressBookWeights.length == 0 || nextAddressBookVerifyingKeys == null || nextAddressBookVerifyingKeys.length == 0 || nextAddressBookWeights == null || nextAddressBookWeights.length == 0 || nextAddressBookHintsVerificationKeyHash == null || nextAddressBookHintsVerificationKeyHash.length == 0 || signatures == null || signatures.length == 0 || !HintsLibraryBridge.validateWeightsSum((long[])currentAddressBookWeights) || !HintsLibraryBridge.validateWeightsSum((long[])nextAddressBookWeights)) {
            return null;
        }
        if (currentAddressBookVerifyingKeys.length != currentAddressBookWeights.length || signatures.length != currentAddressBookWeights.length || nextAddressBookVerifyingKeys.length != nextAddressBookWeights.length) {
            return null;
        }
        if (currentAddressBookProof != null && currentAddressBookProof.length == 0) {
            return null;
        }
        return this.proveChainOfTrustImpl(snarkProvingKey, snarkVerifyingKey, genesisAddressBookHash, currentAddressBookVerifyingKeys, currentAddressBookWeights, nextAddressBookVerifyingKeys, nextAddressBookWeights, currentAddressBookProof, nextAddressBookHintsVerificationKeyHash, signatures);
    }

    private native byte[] proveChainOfTrustImpl(byte[] var1, byte[] var2, byte[] var3, byte[][] var4, long[] var5, byte[][] var6, long[] var7, byte[] var8, byte[] var9, byte[][] var10);

    public native boolean verifyChainOfTrust(byte[] var1, byte[] var2);

    public native boolean verifyCompressedChainOfTrust(byte[] var1, byte[] var2);

    static {
        HistoryLibraryBridge.class.getModule().addOpens(INSTANCE_HOLDER.getNativeLibraryPackageName(), SingletonLoader.class.getModule());
    }
}

