/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.metadata;

import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.metadata.hson.Hson;
import io.helidon.service.metadata.DescriptorMetadata;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

record DescriptorMetadataImpl(double weight, TypeName descriptorType, Set<ResolvedType> contracts, Set<ResolvedType> factoryContracts) implements DescriptorMetadata
{
    private static final int CURRENT_DESCRIPTOR_VERSION = 1;
    private static final int DEFAULT_DESCRIPTOR_VERSION = 1;
    private static final String HSON_WEIGHT = "weight";
    private static final String HSON_DESCRIPTOR = "descriptor";
    private static final String HSON_CONTRACTS = "contracts";
    private static final String HSON_FACTORY_CONTRACTS = "factoryContracts";

    static DescriptorMetadata create(String moduleName, String location, Hson.Struct service) {
        int version = service.intValue("version", 1);
        if (version != 1) {
            throw new IllegalStateException("Invalid descriptor version: " + version + " for module \"" + moduleName + "\" loaded from \"" + location + "\", expected version: \"1\", descriptor (if available): " + service.stringValue(HSON_DESCRIPTOR, "N/A"));
        }
        TypeName descriptor = service.stringValue(HSON_DESCRIPTOR).map(TypeName::create).orElseThrow(() -> new IllegalStateException("Could not parse service metadata  for module \"" + moduleName + "\" loaded from \"" + location + "\", missing \"descriptor\" value"));
        double weight = service.doubleValue(HSON_WEIGHT, 100.0);
        Set<ResolvedType> contracts = service.stringArray(HSON_CONTRACTS).orElseGet(List::of).stream().map(ResolvedType::create).collect(Collectors.toUnmodifiableSet());
        Set<ResolvedType> factoryContracts = service.stringArray(HSON_FACTORY_CONTRACTS).orElseGet(List::of).stream().map(ResolvedType::create).collect(Collectors.toSet());
        return new DescriptorMetadataImpl(weight, descriptor, contracts, factoryContracts);
    }

    @Override
    public Hson.Struct toHson() {
        Hson.Struct.Builder builder = Hson.structBuilder();
        if (this.weight != 100.0) {
            builder.set(HSON_WEIGHT, this.weight);
        }
        builder.set(HSON_DESCRIPTOR, this.descriptorType.fqName());
        builder.setStrings(HSON_CONTRACTS, this.contracts.stream().map(ResolvedType::resolvedName).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toUnmodifiableList()));
        if (!this.factoryContracts.isEmpty()) {
            builder.setStrings(HSON_FACTORY_CONTRACTS, this.factoryContracts.stream().map(ResolvedType::resolvedName).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toUnmodifiableList()));
        }
        return (Hson.Struct)builder.build();
    }
}

