/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.state.roster.RosterState;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.Pair;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.cert.CertificateEncodingException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.hiero.consensus.model.roster.Address;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.InvalidAddressBookException;

public final class RosterRetriever {
    private static final String ROSTER_SERVICE = "RosterService";
    private static final String IP_ADDRESS_COMPONENT_REGEX = "(\\d{1,2}|(?:0|1)\\d{2}|2[0-4]\\d|25[0-5])";
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("^%N\\.%N\\.%N\\.%N$".replace("%N", "(\\d{1,2}|(?:0|1)\\d{2}|2[0-4]\\d|25[0-5])"));

    private RosterRetriever() {
    }

    @Nullable
    public static Roster retrievePreviousRoster(@NonNull State state) {
        ReadableSingletonState rosterState = state.getReadableStates(ROSTER_SERVICE).getSingleton("ROSTER_STATE");
        List roundRosterPairs = Objects.requireNonNull((RosterState)rosterState.get()).roundRosterPairs();
        if (roundRosterPairs.size() < 2) {
            return null;
        }
        return RosterRetriever.retrieveInternal(state, ((RoundRosterPair)roundRosterPairs.get(1)).activeRosterHash());
    }

    @Nullable
    public static Roster retrieveActive(@NonNull State state, long round) {
        return RosterRetriever.retrieveInternal(state, RosterRetriever.getActiveRosterHash(state, round));
    }

    @Nullable
    public static Roster retrieveCandidate(@NonNull State state) {
        return RosterRetriever.retrieveInternal(state, RosterRetriever.getCandidateRosterHash(state));
    }

    @Nullable
    public static Bytes getActiveRosterHash(@NonNull State state, long round) {
        ReadableSingletonState rosterState = state.getReadableStates(ROSTER_SERVICE).getSingleton("ROSTER_STATE");
        List roundRosterPairs = Objects.requireNonNull((RosterState)rosterState.get()).roundRosterPairs();
        for (RoundRosterPair roundRosterPair : roundRosterPairs) {
            if (roundRosterPair.roundNumber() > round) continue;
            return roundRosterPair.activeRosterHash();
        }
        return null;
    }

    @NonNull
    public static Bytes getCandidateRosterHash(@NonNull State state) {
        ReadableSingletonState rosterState = state.getReadableStates(ROSTER_SERVICE).getSingleton("ROSTER_STATE");
        return Objects.requireNonNull((RosterState)rosterState.get()).candidateRosterHash();
    }

    @NonNull
    public static RosterEntry buildRosterEntry(@NonNull Address address) {
        try {
            Bytes cert = address.getSigCert() == null ? Bytes.EMPTY : Bytes.wrap((byte[])address.getSigCert().getEncoded());
            return RosterEntry.newBuilder().nodeId(address.getNodeId().id()).weight(address.getWeight()).gossipCaCertificate(cert).gossipEndpoint(Stream.of(Pair.of((Object)address.getHostnameExternal(), (Object)address.getPortExternal()), Pair.of((Object)address.getHostnameInternal(), (Object)address.getPortInternal())).filter(pair -> pair.left() != null && !((String)pair.left()).isBlank() && (Integer)pair.right() != 0).distinct().map(pair -> {
                Matcher matcher = IP_ADDRESS_PATTERN.matcher((CharSequence)pair.left());
                if (!matcher.matches()) {
                    return ServiceEndpoint.newBuilder().domainName((String)pair.left()).port(((Integer)pair.right()).intValue()).build();
                }
                try {
                    return ServiceEndpoint.newBuilder().ipAddressV4(Bytes.wrap((byte[])new byte[]{(byte)Integer.parseInt(matcher.group(1)), (byte)Integer.parseInt(matcher.group(2)), (byte)Integer.parseInt(matcher.group(3)), (byte)Integer.parseInt(matcher.group(4))})).port(((Integer)pair.right()).intValue()).build();
                }
                catch (NumberFormatException e) {
                    throw new InvalidAddressBookException(e);
                }
            }).toList()).build();
        }
        catch (CertificateEncodingException e) {
            throw new InvalidAddressBookException(e);
        }
    }

    @Nullable
    public static Roster buildRoster(@Nullable AddressBook addressBook) {
        if (addressBook == null) {
            return null;
        }
        return Roster.newBuilder().rosterEntries(addressBook.getNodeIdSet().stream().map(arg_0 -> ((AddressBook)addressBook).getAddress(arg_0)).map(RosterRetriever::buildRosterEntry).sorted(Comparator.comparing(RosterEntry::nodeId)).toList()).build();
    }

    @Nullable
    private static Roster retrieveInternal(@NonNull State state, @Nullable Bytes activeRosterHash) {
        if (activeRosterHash != null) {
            ReadableKVState rosterMap = state.getReadableStates(ROSTER_SERVICE).get("ROSTERS");
            return (Roster)rosterMap.get((Object)new ProtoBytes(activeRosterHash));
        }
        return null;
    }
}

