/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.platform.cli.JrsTestReaderCommand;
import com.swirlds.platform.cli.utils.JtrUtils;
import com.swirlds.platform.testreader.JrsReportData;
import com.swirlds.platform.testreader.JrsTestReader;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import picocli.CommandLine;

@CommandLine.Command(name="scrape", mixinStandardHelpOptions=true, description={"Scrape test data from gcp buckets and generate a csv containing test data."})
@SubcommandOf(value=JrsTestReaderCommand.class)
public class JrsTestReaderScapeCommand
extends AbstractCommand {
    private String bucketPrefix;
    private String testDirectory;
    private int days = 7;
    private Path output = Path.of("testData.csv", new String[0]);
    private int threads = 48;

    private JrsTestReaderScapeCommand() {
    }

    @CommandLine.Parameters(description={"The gs bucket to scrape data from"}, index="0")
    private void setBucketPrefix(@NonNull String bucketPrefix) {
        this.bucketPrefix = bucketPrefix;
    }

    @CommandLine.Parameters(description={"The test directory relative to the bucket prefix"}, index="1")
    private void setTestDirectory(@NonNull String testDirectory) {
        this.testDirectory = testDirectory;
    }

    @CommandLine.Option(names={"-d", "--days"}, description={"Specify the number of days in the past to begin scraping from. Defaults to 7."})
    private void setDays(int days) {
        this.days = days;
    }

    @CommandLine.Option(names={"-o", "--output"}, description={"Specify the path to the output csv file. Defaults to 'testData.csv'."})
    private void setOutput(@NonNull Path output) {
        this.output = Objects.requireNonNull(FileUtils.getAbsolutePath((Path)output));
    }

    @CommandLine.Option(names={"-t", "--threads"}, description={"Specify the number of threads to use. Defaults to 48."})
    private void setThreads(int threads) {
        this.threads = threads;
    }

    public Integer call() {
        if (Files.exists(this.output, new LinkOption[0])) {
            try {
                Files.delete(this.output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        JrsReportData data = JtrUtils.scrapeTestData(this.bucketPrefix, this.testDirectory, this.days, this.threads);
        JrsTestReader.saveTestResults(data, this.output);
        return 0;
    }
}

