/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.components.appcomm;

import com.swirlds.common.notification.NotificationResult;
import com.swirlds.platform.components.appcomm.CompleteStateNotificationWithCleanup;
import com.swirlds.platform.components.appcomm.LatestCompleteStateNotifier;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.system.state.notifications.NewSignedStateNotification;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.base.concurrent.futures.StandardFuture;

public class DefaultLatestCompleteStateNotifier
implements LatestCompleteStateNotifier {
    private long latestStateProvidedRound = -1L;

    @Override
    @Nullable
    public CompleteStateNotificationWithCleanup latestCompleteStateHandler(@NonNull ReservedSignedState reservedSignedState) {
        if (reservedSignedState.get().getRound() <= this.latestStateProvidedRound) {
            reservedSignedState.close();
            return null;
        }
        this.latestStateProvidedRound = reservedSignedState.get().getRound();
        NewSignedStateNotification notification = new NewSignedStateNotification(reservedSignedState.get().getState(), reservedSignedState.get().getRound(), reservedSignedState.get().getConsensusTimestamp());
        return new CompleteStateNotificationWithCleanup(notification, (StandardFuture.CompletionCallback<NotificationResult<NewSignedStateNotification>>)((StandardFuture.CompletionCallback)r -> reservedSignedState.close()));
    }
}

