/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.BlockInfo;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.node.app.records.impl.BlockRecordInfoUtils;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public final class BlockRecordInfoImpl
implements BlockRecordInfo {
    private final BlockInfo blockInfo;
    private final RunningHashes runningHashes;

    public static BlockRecordInfoImpl from(@NonNull State state) {
        ReadableStates states = state.getReadableStates("BlockRecordService");
        BlockInfo blockInfoState = Objects.requireNonNull((BlockInfo)states.getSingleton("BLOCKS").get());
        RunningHashes runningHashState = Objects.requireNonNull((RunningHashes)states.getSingleton("RUNNING_HASHES").get());
        return new BlockRecordInfoImpl(blockInfoState, runningHashState);
    }

    public BlockRecordInfoImpl(@NonNull BlockInfo blockInfo, @NonNull RunningHashes runningHashes) {
        this.blockInfo = Objects.requireNonNull(blockInfo);
        this.runningHashes = Objects.requireNonNull(runningHashes);
    }

    public Bytes prngSeed() {
        return this.runningHashes.nMinus3RunningHash();
    }

    public long blockNo() {
        return this.blockInfo.lastBlockNumber() + 1L;
    }

    @NonNull
    public Timestamp blockTimestamp() {
        return this.blockInfo.firstConsTimeOfCurrentBlockOrThrow();
    }

    @Nullable
    public Bytes blockHashByBlockNumber(long blockNo) {
        return BlockRecordInfoUtils.blockHashByBlockNumber(this.blockInfo, blockNo);
    }
}

