/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ReturnDataCopyOperation
extends AbstractOperation {
    protected static final Operation.OperationResult INVALID_RETURN_DATA_BUFFER_ACCESS = new Operation.OperationResult(0L, ExceptionalHaltReason.INVALID_RETURN_DATA_BUFFER_ACCESS);
    protected static final Operation.OperationResult OUT_OF_BOUNDS = new Operation.OperationResult(0L, ExceptionalHaltReason.OUT_OF_BOUNDS);

    public ReturnDataCopyOperation(GasCalculator gasCalculator) {
        super(62, "RETURNDATACOPY", 3, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long memOffset = Words.clampedToLong(frame.popStackItem());
        long sourceOffset = Words.clampedToLong(frame.popStackItem());
        long numBytes = Words.clampedToLong(frame.popStackItem());
        Bytes returnData = frame.getReturnData();
        int returnDataLength = returnData.size();
        try {
            long end = Math.addExact(sourceOffset, numBytes);
            if (end > (long)returnDataLength) {
                return INVALID_RETURN_DATA_BUFFER_ACCESS;
            }
        }
        catch (ArithmeticException ae) {
            return OUT_OF_BOUNDS;
        }
        long cost = this.gasCalculator().dataCopyOperationGasCost(frame, memOffset, numBytes);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.writeMemory(memOffset, sourceOffset, numBytes, returnData, true);
        return new Operation.OperationResult(cost, null);
    }
}

