/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.metrics.platform;

import com.swirlds.metrics.api.Metric;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hiero.consensus.model.node.NodeId;

public class MetricKeyRegistry {
    private final Map<String, Registration> registrations = new HashMap<String, Registration>();

    public synchronized boolean register(NodeId nodeId, String key, Class<? extends Metric> clazz) {
        Registration registration = this.registrations.computeIfAbsent(key, k -> new Registration(nodeId == null ? null : new HashSet<NodeId>(), clazz));
        if (registration.clazz == clazz) {
            if (nodeId == null) {
                return registration.nodeIds == null;
            }
            if (registration.nodeIds != null) {
                registration.nodeIds.add(nodeId);
                return true;
            }
        }
        return false;
    }

    public synchronized void unregister(NodeId nodeId, String key) {
        if (nodeId == null) {
            this.registrations.computeIfPresent(key, (k, v) -> v.nodeIds == null ? null : v);
        } else {
            Registration registration = this.registrations.get(key);
            if (registration != null && registration.nodeIds != null) {
                registration.nodeIds.remove(nodeId);
                if (registration.nodeIds.isEmpty()) {
                    this.registrations.remove(key);
                }
            }
        }
    }

    private record Registration(Set<NodeId> nodeIds, Class<? extends Metric> clazz) {
    }
}

