/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.api;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public record ContractChangeSummary(List<ContractID> newContractIds, List<ContractNonceInfo> updatedContractNonces) {
    public static final Comparator<ContractID> CONTRACT_ID_NUM_COMPARATOR = Comparator.comparingLong(ContractID::contractNumOrThrow);
    public static final Comparator<ContractNonceInfo> NONCE_INFO_CONTRACT_ID_COMPARATOR = Comparator.comparing(ContractNonceInfo::contractIdOrThrow, CONTRACT_ID_NUM_COMPARATOR);

    public ContractChangeSummary {
        Objects.requireNonNull(newContractIds).sort(CONTRACT_ID_NUM_COMPARATOR);
        Objects.requireNonNull(updatedContractNonces).sort(NONCE_INFO_CONTRACT_ID_COMPARATOR);
    }
}

