/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.LogBuilder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.grantapproval.ClassicGrantApprovalCall;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class GrantApprovalLoggingUtils {
    private GrantApprovalLoggingUtils() {
    }

    public static void logSuccessfulFTApprove(@NonNull TokenID tokenId, @NonNull AccountID sender, @NonNull AccountID spender, long amount, @NonNull ReadableAccountStore accountStore, @NonNull MessageFrame frame) {
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(frame);
        Objects.requireNonNull(sender);
        Objects.requireNonNull(spender);
        Objects.requireNonNull(accountStore);
        frame.addLog(GrantApprovalLoggingUtils.builderFor(tokenId, sender, spender, accountStore).forDataItem(amount).build());
    }

    public static void logSuccessfulNFTApprove(@NonNull TokenID tokenId, @NonNull AccountID sender, @NonNull AccountID spender, long amount, @NonNull ReadableAccountStore accountStore, @NonNull MessageFrame frame) {
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(frame);
        Objects.requireNonNull(sender);
        Objects.requireNonNull(spender);
        Objects.requireNonNull(accountStore);
        frame.addLog(GrantApprovalLoggingUtils.builderFor(tokenId, sender, spender, accountStore).forIndexedArgument(amount).build());
    }

    private static LogBuilder builderFor(@NonNull TokenID tokenId, @NonNull AccountID senderId, @NonNull AccountID spenderId, @NonNull ReadableAccountStore accountStore) {
        Address tokenAddress = ConversionUtils.asLongZeroAddress(tokenId.tokenNum());
        Address senderAddress = ConversionUtils.priorityAddressOf(Objects.requireNonNull(accountStore.getAccountById(senderId)));
        Account spenderAccount = accountStore.getAccountById(spenderId);
        Bytes spenderAddress = spenderAccount != null ? ConversionUtils.priorityAddressOf(spenderAccount) : Bytes.EMPTY;
        return LogBuilder.logBuilder().forLogger(tokenAddress).forEventSignature(ClassicGrantApprovalCall.APPROVAL_EVENT).forIndexedArgument(senderAddress).forIndexedArgument(spenderAddress);
    }
}

