/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.setapproval;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.token.NftAllowance;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.setapproval.SetApprovalForAllTranslator;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SetApprovalForAllDecoder {
    @Inject
    public SetApprovalForAllDecoder() {
    }

    public TransactionBody decodeSetApprovalForAll(@NonNull HtsCallAttempt attempt) {
        Tuple call = SetApprovalForAllTranslator.SET_APPROVAL_FOR_ALL.decodeCall(attempt.inputBytes());
        AccountID operatorId = attempt.addressIdConverter().convert((Address)call.get(1));
        return this.bodyOf(this.approveAllAllowanceNFTBody(attempt.senderId(), ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0)), operatorId, (Boolean)call.get(2)));
    }

    public TransactionBody decodeSetApprovalForAllERC(@NonNull HtsCallAttempt attempt) {
        Tuple call = SetApprovalForAllTranslator.ERC721_SET_APPROVAL_FOR_ALL.decodeCall(attempt.inputBytes());
        TokenID tokenId = attempt.redirectTokenId();
        Objects.requireNonNull(tokenId, "Redirect Token ID is null.");
        AccountID operatorId = attempt.addressIdConverter().convert((Address)call.get(0));
        return this.bodyOf(this.approveAllAllowanceNFTBody(attempt.senderId(), tokenId, operatorId, (Boolean)call.get(1)));
    }

    private CryptoApproveAllowanceTransactionBody approveAllAllowanceNFTBody(@NonNull AccountID senderId, @NonNull TokenID tokenID, @NonNull AccountID operatorId, boolean approved) {
        return CryptoApproveAllowanceTransactionBody.newBuilder().nftAllowances(new NftAllowance[]{NftAllowance.newBuilder().tokenId(tokenID).owner(senderId).spender(operatorId).approvedForAll(Boolean.valueOf(approved)).build()}).build();
    }

    private TransactionBody bodyOf(@NonNull CryptoApproveAllowanceTransactionBody approveAllowanceTransactionBody) {
        return TransactionBody.newBuilder().cryptoApproveAllowance(approveAllowanceTransactionBody).build();
    }
}

