/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.NoSuchElementException;

public final class RoundCalculationUtils {
    private RoundCalculationUtils() {
    }

    public static long getOldestNonAncientRound(int roundsNonAncient, long lastRoundDecided) {
        return Math.max(lastRoundDecided - (long)roundsNonAncient + 1L, 1L);
    }

    public static long getAncientThreshold(int roundsNonAncient, @NonNull ConsensusSnapshot snapshot) {
        long oldestNonAncientRound = RoundCalculationUtils.getOldestNonAncientRound(roundsNonAncient, snapshot.round());
        return RoundCalculationUtils.getMinimumJudgeAncientThreshold(oldestNonAncientRound, snapshot);
    }

    public static long getMinimumJudgeAncientThreshold(long round, @NonNull ConsensusSnapshot snapshot) {
        for (MinimumJudgeInfo info : snapshot.minimumJudgeInfoList()) {
            if (info.round() != round) continue;
            return info.minimumJudgeBirthRound();
        }
        throw new NoSuchElementException("No minimum judge info found for round: " + round);
    }
}

