/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.hedera.hapi.node.state.roster.Roster;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.hiero.base.iterator.TypedIterator;
import org.hiero.consensus.model.event.CesEvent;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.Round;

public class StreamedRound
implements Round {
    private final List<CesEvent> events;
    private final long roundNumber;
    private final Instant consensusTimestamp;
    private final Roster consensusRoster;

    public StreamedRound(@NonNull Roster consensusRoster, @NonNull List<CesEvent> events, long roundNumber) {
        this.events = events;
        this.roundNumber = roundNumber;
        events.stream().map(CesEvent::getPlatformEvent).forEach(PlatformEvent::setConsensusTimestampsOnTransactions);
        this.consensusTimestamp = events.get(events.size() - 1).getPlatformEvent().getConsensusTimestamp();
        this.consensusRoster = Objects.requireNonNull(consensusRoster);
    }

    @NonNull
    public Iterator<ConsensusEvent> iterator() {
        return new TypedIterator(this.events.iterator());
    }

    @NonNull
    public List<CesEvent> getEvents() {
        return this.events;
    }

    public long getRoundNum() {
        return this.roundNumber;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public int getEventCount() {
        return this.events.size();
    }

    @NonNull
    public Roster getConsensusRoster() {
        return this.consensusRoster;
    }

    @NonNull
    public Instant getConsensusTimestamp() {
        return this.consensusTimestamp;
    }
}

