/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.token.impl.handlers.transfer.EnsureAliasesStep;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferContextImpl;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;

public class ReplaceAliasesWithIDsInOp {
    public CryptoTransferTransactionBody replaceAliasesWithIds(@NonNull CryptoTransferTransactionBody op, @NonNull TransferContextImpl transferContext) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(transferContext);
        Map<Bytes, AccountID> resolutions = transferContext.resolutions();
        CryptoTransferTransactionBody.Builder replacedAliasesOp = CryptoTransferTransactionBody.newBuilder();
        TransferList.Builder transferList = TransferList.newBuilder();
        ArrayList<TokenTransferList> tokenTransfersList = new ArrayList<TokenTransferList>();
        ArrayList<AccountAmount> accountAmounts = new ArrayList<AccountAmount>();
        for (AccountAmount aa : op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            if (EnsureAliasesStep.isAlias(aa.accountIDOrThrow())) {
                AccountID resolvedId = resolutions.get(aa.accountIDOrThrow().alias());
                accountAmounts.add(aa.copyBuilder().accountID(resolvedId).build());
                continue;
            }
            accountAmounts.add(aa);
        }
        transferList.accountAmounts(accountAmounts);
        replacedAliasesOp.transfers(transferList);
        for (TokenTransferList adjust : op.tokenTransfers()) {
            TokenTransferList.Builder tokenTransferList = TokenTransferList.newBuilder().token(adjust.token());
            if (adjust.hasExpectedDecimals()) {
                tokenTransferList.expectedDecimals(adjust.expectedDecimals());
            }
            ArrayList<AccountAmount> replacedTokenAdjusts = new ArrayList<AccountAmount>();
            for (AccountAmount tokenAdjust : adjust.transfers()) {
                if (EnsureAliasesStep.isAlias(tokenAdjust.accountIDOrThrow())) {
                    AccountID resolvedId = resolutions.get(tokenAdjust.accountID().alias());
                    replacedTokenAdjusts.add(tokenAdjust.copyBuilder().accountID(resolvedId).build());
                    continue;
                }
                replacedTokenAdjusts.add(tokenAdjust);
            }
            if (!replacedTokenAdjusts.isEmpty()) {
                tokenTransferList.transfers(replacedTokenAdjusts);
            }
            ArrayList<NftTransfer> replacedNftAdjusts = new ArrayList<NftTransfer>();
            for (NftTransfer nftAdjust : adjust.nftTransfers()) {
                NftTransfer.Builder nftAdjustCopy = nftAdjust.copyBuilder();
                boolean isReceiverAlias = EnsureAliasesStep.isAlias(nftAdjust.receiverAccountIDOrThrow());
                boolean isSenderAlias = EnsureAliasesStep.isAlias(nftAdjust.senderAccountIDOrThrow());
                if (isReceiverAlias || isSenderAlias) {
                    AccountID resolvedId;
                    if (isReceiverAlias) {
                        resolvedId = resolutions.get(nftAdjust.receiverAccountIDOrThrow().alias());
                        nftAdjustCopy.receiverAccountID(resolvedId);
                    }
                    if (isSenderAlias) {
                        resolvedId = resolutions.get(nftAdjust.senderAccountIDOrThrow().alias());
                        nftAdjustCopy.senderAccountID(resolvedId);
                    }
                    replacedNftAdjusts.add(nftAdjustCopy.build());
                    continue;
                }
                replacedNftAdjusts.add(nftAdjust);
            }
            if (!replacedNftAdjusts.isEmpty()) {
                tokenTransferList.nftTransfers(replacedNftAdjusts);
            }
            tokenTransfersList.add(tokenTransferList.build());
        }
        replacedAliasesOp.tokenTransfers(tokenTransfersList);
        return replacedAliasesOp.build();
    }
}

