/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.ethereum.rlp;

import java.math.BigInteger;
import java.net.InetAddress;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.apache.tuweni.units.bigints.UInt64Value;
import org.hyperledger.besu.ethereum.rlp.RLP;

public interface RLPOutput {
    public void startList();

    public void endList();

    public void writeBytes(Bytes var1);

    default public void writeUInt64Scalar(UInt64Value<?> v) {
        this.writeBytes(v.toBytes().trimLeadingZeros());
    }

    default public void writeUInt256Scalar(UInt256Value<?> v) {
        this.writeBytes(v.trimLeadingZeros());
    }

    default public void writeNull() {
        this.writeBytes(Bytes.EMPTY);
    }

    default public void writeIntScalar(int v) {
        this.writeLongScalar(v);
    }

    default public void writeLongScalar(long v) {
        this.writeBytes(Bytes.minimalBytes((long)v));
    }

    default public void writeBigIntegerScalar(BigInteger v) {
        if (v.equals(BigInteger.ZERO)) {
            this.writeBytes(Bytes.EMPTY);
            return;
        }
        byte[] bytes = v.toByteArray();
        this.writeBytes(bytes.length > 1 && bytes[0] == 0 ? Bytes.wrap((byte[])bytes, (int)1, (int)(bytes.length - 1)) : Bytes.wrap((byte[])bytes));
    }

    default public void writeByte(byte b) {
        this.writeBytes(Bytes.of((byte[])new byte[]{b}));
    }

    default public void writeShort(short s) {
        byte[] res = new byte[]{(byte)(s >> 8), (byte)s};
        this.writeBytes(Bytes.wrap((byte[])res));
    }

    default public void writeInt(int i) {
        MutableBytes v = MutableBytes.create((int)4);
        v.setInt(0, i);
        this.writeBytes((Bytes)v);
    }

    default public void writeLong(long l) {
        MutableBytes v = MutableBytes.create((int)8);
        v.setLong(0, l);
        this.writeBytes((Bytes)v);
    }

    default public void writeUnsignedByte(int b) {
        this.processZeroByte(Long.valueOf(b), a -> this.writeBytes(Bytes.of((int[])new int[]{b})));
    }

    default public void writeUnsignedShort(int s) {
        this.processZeroByte(Long.valueOf(s), a -> this.writeBytes(Bytes.ofUnsignedShort((int)s).trimLeadingZeros()));
    }

    default public void writeUnsignedInt(long i) {
        this.processZeroByte(i, a -> this.writeBytes(Bytes.ofUnsignedInt((long)i).trimLeadingZeros()));
    }

    default public void writeInetAddress(InetAddress address) {
        this.writeBytes(Bytes.wrap((byte[])address.getAddress()));
    }

    default public <T> void writeList(Iterable<T> values, BiConsumer<T, RLPOutput> valueWriter) {
        this.startList();
        for (T v : values) {
            valueWriter.accept(v, this);
        }
        this.endList();
    }

    default public void writeEmptyList() {
        this.startList();
        this.endList();
    }

    default public void writeRLPBytes(Bytes rlpEncodedValue) {
        RLP.validate(rlpEncodedValue);
        this.writeRaw(rlpEncodedValue);
    }

    public void writeRaw(Bytes var1);

    private void processZeroByte(Long input, Consumer<Long> writer) {
        if (input == 0L) {
            this.writeRaw(Bytes.of((int[])new int[]{128}));
        } else {
            writer.accept(input);
        }
    }
}

