/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.threading.framework.QueueThread;
import com.swirlds.common.threading.framework.QueueThreadPool;
import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.framework.ThreadSeed;
import com.swirlds.common.threading.framework.internal.AbstractBlockingQueue;
import com.swirlds.common.threading.framework.internal.AbstractQueueThreadPoolConfiguration;
import com.swirlds.common.threading.framework.internal.ThreadBuildingUtils;
import java.util.ArrayList;
import java.util.List;

public class QueueThreadPoolImpl<T>
extends AbstractBlockingQueue<T>
implements QueueThreadPool<T> {
    private final List<QueueThread<T>> threads = new ArrayList<QueueThread<T>>();

    protected QueueThreadPoolImpl(AbstractQueueThreadPoolConfiguration<?, T> configuration) {
        super(ThreadBuildingUtils.getOrBuildQueue(configuration));
        configuration.enableThreadNumbering();
        for (int threadIndex = 0; threadIndex < configuration.getThreadCount(); ++threadIndex) {
            this.threads.add(configuration.copy().buildQueueThread(false));
        }
    }

    @Override
    public List<ThreadSeed> buildSeeds() {
        ArrayList<ThreadSeed> seeds = new ArrayList<ThreadSeed>(this.threads.size());
        for (QueueThread<T> thread : this.threads) {
            seeds.add(thread.buildSeed());
        }
        return seeds;
    }

    @Override
    public void start() {
        for (QueueThread<T> thread : this.threads) {
            thread.start();
        }
    }

    @Override
    public boolean stop() {
        boolean success = true;
        for (QueueThread<T> thread : this.threads) {
            success &= thread.stop();
        }
        return success;
    }

    @Override
    public boolean stop(Stoppable.StopBehavior behavior) {
        boolean success = true;
        for (QueueThread<T> thread : this.threads) {
            success &= thread.stop(behavior);
        }
        return success;
    }

    @Override
    public boolean pause() {
        boolean success = true;
        for (QueueThread<T> thread : this.threads) {
            success &= thread.pause();
        }
        return success;
    }

    @Override
    public boolean resume() {
        boolean success = true;
        for (QueueThread<T> thread : this.threads) {
            success &= thread.resume();
        }
        return success;
    }

    @Override
    public void join() throws InterruptedException {
        for (QueueThread<T> thread : this.threads) {
            thread.join();
        }
    }

    @Override
    public void join(long millis) throws InterruptedException {
        for (QueueThread<T> thread : this.threads) {
            thread.join(millis);
        }
    }

    @Override
    public void join(long millis, int nanos) throws InterruptedException {
        for (QueueThread<T> thread : this.threads) {
            thread.join(millis, nanos);
        }
    }

    public String toString() {
        if (this.threads.isEmpty()) {
            return "QueueThreadPool(0)";
        }
        return "QueueThreadPool(" + this.threads.get(0).getName() + ")";
    }
}

