/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.webserver.spi.ServerConnectionSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConnectionProviders {
    private final List<ServerConnectionSelector> connectionProviders;
    private final Set<String> supportedAppProtocols;
    private final Map<String, ServerConnectionSelector> providersByAppProtocol;

    private ConnectionProviders(List<ServerConnectionSelector> connectionProviders) {
        this.connectionProviders = connectionProviders;
        LinkedHashSet<String> supportedAppProtocols = new LinkedHashSet<String>();
        HashMap<String, ServerConnectionSelector> byAppProtocol = new HashMap<String, ServerConnectionSelector>();
        for (ServerConnectionSelector provider : connectionProviders) {
            supportedAppProtocols.addAll(provider.supportedApplicationProtocols());
            for (String protocol : provider.supportedApplicationProtocols()) {
                byAppProtocol.putIfAbsent(protocol, provider);
            }
        }
        this.supportedAppProtocols = Set.copyOf(supportedAppProtocols);
        this.providersByAppProtocol = Map.copyOf(byAppProtocol);
    }

    public static ConnectionProviders create(List<ServerConnectionSelector> connectionProviders) {
        return new ConnectionProviders(connectionProviders);
    }

    public List<ServerConnectionSelector> providerCandidates() {
        return new ArrayList<ServerConnectionSelector>(this.connectionProviders);
    }

    public Set<String> supportedApplicationProtocols() {
        return this.supportedAppProtocols;
    }

    public ServerConnectionSelector byApplicationProtocol(String protocol) {
        return this.providersByAppProtocol.get(protocol);
    }
}

