/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.internal;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gui.GuiConstants;
import com.swirlds.platform.gui.GuiUtils;
import com.swirlds.platform.gui.components.PrePaintableJPanel;
import com.swirlds.platform.gui.internal.BrowserWindowManager;
import com.swirlds.platform.gui.internal.WinBrowser;
import com.swirlds.platform.gui.model.InfoApp;
import com.swirlds.platform.gui.model.InfoEntity;
import com.swirlds.platform.gui.model.InfoMember;
import com.swirlds.platform.gui.model.InfoSwirld;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class WinTabSwirlds
extends PrePaintableJPanel {
    private static final long serialVersionUID = 1L;
    private JTextPane lastText = null;
    private static final Logger logger = LogManager.getLogger(WinTabSwirlds.class);
    private JTextPane instructions;
    private boolean redoWindow = true;

    public WinTabSwirlds() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setFont(GuiConstants.FONT);
        this.chooseMemberDisplayed();
        this.instructions = new JTextPane();
        this.instructions.setText(GuiUtils.wrap(70, "\n\nThe above are all of the known apps in the data/apps directory. Under each app is all of the known swirlds (i.e., shared worlds, shared ledgers, shared databases). Under each swirld is all of the known members using this local machine. Each one that is currently active is marked as \"running\". Click on a member to show their information in all the tabs here. Minimize this window to hide it. Close it to quit the entire program."));
        this.freeze(this.instructions);
    }

    @Override
    public void prePaint() {
        if (!this.redoWindow) {
            return;
        }
        this.redoWindow = false;
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        for (InfoApp app : BrowserWindowManager.getStateHierarchy().apps) {
            this.addEntity(this, app, c, 0, "", false);
            ++c.gridy;
            for (InfoSwirld swirld : app.getSwirlds()) {
                this.addEntity(this, swirld, c, 1, "", false);
                ++c.gridy;
                for (InfoMember member : swirld.getMembers()) {
                    if (WinBrowser.memberDisplayed == null) {
                        this.setMemberDisplayed(member);
                    }
                    this.addEntity(this, member, c, 2, "", true);
                    ++c.gridy;
                }
            }
        }
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(10, 10, 10, 10);
        this.add((Component)this.instructions, c);
        ++c.gridy;
        if (this.lastText == null) {
            this.lastText = new JTextPane();
            this.lastText.setText("");
            this.freeze(this.lastText);
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)this.lastText, c);
            ++c.gridy;
        }
    }

    void setMemberDisplayed(InfoMember member) {
        WinBrowser.memberDisplayed = member;
        WinBrowser.nameBarName.setText("    " + member.getName() + "    ");
        for (InfoApp app : BrowserWindowManager.getStateHierarchy().apps) {
            for (InfoSwirld swirld : app.getSwirlds()) {
                for (InfoMember mem : swirld.getMembers()) {
                    if (mem.getPanel() == null) continue;
                    ((EntityRow)mem.getPanel()).setColor(WinBrowser.memberDisplayed == mem ? GuiConstants.MEMBER_HIGHLIGHT_COLOR : Color.WHITE);
                }
            }
        }
    }

    void addEntity(WinTabSwirlds parent, InfoEntity entity, GridBagConstraints c, int level, String suffix, boolean selectable) {
        if (entity.getPanel() != null) {
            return;
        }
        EntityRow row = new EntityRow(entity, level, suffix, selectable);
        row.setColor(WinBrowser.memberDisplayed == entity ? GuiConstants.MEMBER_HIGHLIGHT_COLOR : Color.WHITE);
        this.add((Component)row, c);
    }

    void freeze(JTextPane text) {
        text.setFont(GuiConstants.FONT);
        text.setEditable(false);
        text.setEnabled(false);
        text.setBackground(Color.WHITE);
        text.setForeground(Color.BLACK);
        text.setDisabledTextColor(Color.BLACK);
    }

    void chooseMemberDisplayed() {
        try {
            for (InfoApp app : BrowserWindowManager.getStateHierarchy().apps) {
                for (InfoSwirld swirld : app.getSwirlds()) {
                    for (InfoMember member : swirld.getMembers()) {
                        if (WinBrowser.memberDisplayed != null) continue;
                        this.setMemberDisplayed(member);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    class EntityRow
    extends JPanel {
        private static final long serialVersionUID = 1L;
        InfoEntity member;
        int level;
        JPanel indent;
        JTextPane name;
        JTextPane suf;

        void setColor(Color color) {
            this.setBackground(Color.WHITE);
            this.indent.setBackground(Color.WHITE);
            this.name.setBackground(color);
            this.suf.setBackground(color);
        }

        EntityRow(InfoEntity entity, int level, String suffix, boolean selectable) {
            this.member = entity;
            this.level = level;
            this.indent = new JPanel();
            this.name = new JTextPane();
            this.suf = new JTextPane();
            if (selectable) {
                this.indent.addMouseListener(new ClickToSelect(entity));
                this.name.addMouseListener(new ClickToSelect(entity));
                this.suf.addMouseListener(new ClickToSelect(entity));
                this.addMouseListener(new ClickToSelect(entity));
            }
            this.setLayout(new FlowLayout(3, 0, 2));
            this.indent.setPreferredSize(new Dimension(30 * level, 10));
            this.indent.setMinimumSize(new Dimension(30 * level, 10));
            this.name.setText("    " + entity.getName() + "    ");
            WinTabSwirlds.this.freeze(this.name);
            WinTabSwirlds.this.freeze(this.suf);
            this.suf.setText(suffix);
            this.add(this.indent);
            this.add(this.name);
            this.add(this.suf);
            entity.setPanel(this);
        }
    }

    private class ClickToSelect
    extends MouseAdapter {
        InfoMember member;

        ClickToSelect(InfoEntity member) {
            if (!(member instanceof InfoMember)) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "WinTabSwirlds.ClickToSelect instantiated with {} which is not an InfoMember", (Object)member);
                return;
            }
            this.member = (InfoMember)member;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                WinTabSwirlds.this.setMemberDisplayed(this.member);
            }
        }
    }
}

