/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.engine;

import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.HashingOutputStream;
import org.hiero.base.crypto.engine.CachingOperationProvider;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class SerializationDigestProvider
extends CachingOperationProvider<SelfSerializable, Void, byte[], HashingOutputStream, DigestType> {
    @Override
    protected HashingOutputStream handleAlgorithmRequired(DigestType algorithmType) throws NoSuchAlgorithmException {
        return new HashingOutputStream(MessageDigest.getInstance(algorithmType.algorithmName()));
    }

    @Override
    protected byte[] handleItem(HashingOutputStream algorithm, DigestType algorithmType, SelfSerializable item, Void optionalData) {
        byte[] byArray;
        algorithm.resetDigest();
        SerializableDataOutputStream out = new SerializableDataOutputStream((OutputStream)algorithm);
        try {
            out.writeSerializable(item, true);
            out.flush();
            byArray = algorithm.getDigest();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new CryptographyException(ex, LogMarker.EXCEPTION);
            }
        }
        out.close();
        return byArray;
    }
}

