/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.allowance;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.allowance.GetAllowanceTranslator;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GetAllowanceCall
extends AbstractCall {
    private final Address owner;
    private final Address spender;
    private final AddressIdConverter addressIdConverter;
    private final boolean isERCCall;
    private final boolean isStaticCall;
    @Nullable
    private final Token token;

    @Inject
    public GetAllowanceCall(@NonNull AddressIdConverter addressIdConverter, @NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token, @NonNull Address owner, @NonNull Address spender, boolean isERCCall, boolean isStaticCall) {
        super(gasCalculator, enhancement, true);
        this.addressIdConverter = Objects.requireNonNull(addressIdConverter);
        this.token = token;
        this.owner = Objects.requireNonNull(owner);
        this.spender = Objects.requireNonNull(spender);
        this.isERCCall = isERCCall;
        this.isStaticCall = isStaticCall;
    }

    @Override
    public boolean allowsStaticFrame() {
        return true;
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        long gasRequirement = this.gasCalculator.viewGasRequirement();
        if (this.token == null || this.token.tokenType() != TokenType.FUNGIBLE_COMMON) {
            if (this.isStaticCall) {
                return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_TOKEN_ID, gasRequirement), ResponseCodeEnum.INVALID_TOKEN_ID, false);
            }
            return Call.PricedResult.gasOnly(FullResult.successResult(this.encodedAllowanceOutput(BigInteger.ZERO), gasRequirement), ResponseCodeEnum.SUCCESS, false);
        }
        AccountID ownerId = this.addressIdConverter.convert(this.owner);
        Account ownerAccount = this.nativeOperations().getAccount(ownerId);
        if (ownerAccount == null) {
            return Call.PricedResult.gasOnly(FullResult.revertResult(ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID, gasRequirement), ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID, true);
        }
        AccountID spenderId = this.addressIdConverter.convert(this.spender);
        BigInteger allowance = this.getAllowance(this.token, ownerAccount, spenderId);
        return Call.PricedResult.gasOnly(FullResult.successResult(this.encodedAllowanceOutput(allowance), gasRequirement), ResponseCodeEnum.SUCCESS, true);
    }

    @NonNull
    private BigInteger getAllowance(@NonNull Token token, @NonNull Account ownerAccount, @NonNull AccountID spenderID) {
        Optional<AccountFungibleTokenAllowance> tokenAllowance = Objects.requireNonNull(ownerAccount).tokenAllowances().stream().filter(allowance -> allowance.tokenIdOrThrow().equals((Object)token.tokenIdOrThrow()) && allowance.spenderIdOrThrow().equals((Object)spenderID)).findFirst();
        return BigInteger.valueOf(tokenAllowance.map(AccountFungibleTokenAllowance::amount).orElse(0L));
    }

    @NonNull
    private ByteBuffer encodedAllowanceOutput(@NonNull BigInteger allowance) {
        if (this.isERCCall) {
            return GetAllowanceTranslator.ERC_GET_ALLOWANCE.getOutputs().encode((Object)Tuple.singleton((Object)allowance));
        }
        return GetAllowanceTranslator.GET_ALLOWANCE.getOutputs().encode((Object)Tuple.of((Object)ResponseCodeEnum.SUCCESS.protoOrdinal(), (Object)allowance));
    }
}

