/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.node.app.service.networkadmin.ReadableFreezeStore;
import com.hedera.node.app.service.networkadmin.impl.WritableFreezeStore;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableFreezeStoreImpl
implements ReadableFreezeStore {
    private final ReadableSingletonState<Timestamp> freezeTime;
    private final ReadableSingletonState<ProtoBytes> updateFileHash;

    public ReadableFreezeStoreImpl(@NonNull ReadableStates states) {
        Objects.requireNonNull(states);
        this.freezeTime = states.getSingleton("FREEZE_TIME");
        this.updateFileHash = states.getSingleton("UPGRADE_FILE_HASH");
    }

    @Nullable
    public Timestamp freezeTime() {
        return (Timestamp)this.freezeTime.get();
    }

    @Nullable
    public Bytes updateFileHash() {
        return WritableFreezeStore.effectiveUpdateFileHash((ProtoBytes)this.updateFileHash.get());
    }
}

