/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.grpc;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.helidon.builder.api.RuntimeType;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.grpc.GrpcClientConfig;
import io.helidon.webclient.grpc.GrpcClientImpl;
import io.helidon.webclient.grpc.GrpcClientProtocolConfig;
import io.helidon.webclient.grpc.GrpcProtocolProvider;
import io.helidon.webclient.grpc.GrpcServiceClient;
import io.helidon.webclient.grpc.GrpcServiceDescriptor;
import io.helidon.webclient.spi.Protocol;
import java.util.Collection;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=GrpcClientConfig.class)
public interface GrpcClient
extends RuntimeType.Api<GrpcClientConfig> {
    public static final String PROTOCOL_ID = "grpc";
    public static final Protocol<GrpcClient, GrpcClientProtocolConfig> PROTOCOL = GrpcProtocolProvider::new;

    public static GrpcClientConfig.Builder builder() {
        return GrpcClientConfig.builder();
    }

    public static GrpcClient create(GrpcClientConfig clientConfig) {
        return new GrpcClientImpl(WebClient.create((T it) -> it.from((HttpClientConfig)clientConfig)), clientConfig);
    }

    public static GrpcClient create(Consumer<GrpcClientConfig.Builder> consumer) {
        return GrpcClient.create(((GrpcClientConfig.Builder)GrpcClientConfig.builder().update(consumer)).buildPrototype());
    }

    public static GrpcClient create() {
        return GrpcClient.create(GrpcClientConfig.create());
    }

    public GrpcServiceClient serviceClient(GrpcServiceDescriptor var1);

    public Channel channel();

    public Channel channel(ClientInterceptor ... var1);

    default public Channel channel(Collection<ClientInterceptor> interceptors) {
        return this.channel(interceptors.toArray(new ClientInterceptor[0]));
    }

    public GrpcClientConfig clientConfig();
}

