/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state;

import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WrappedWritableKVState;
import com.swirlds.state.spi.WrappedWritableQueueState;
import com.swirlds.state.spi.WrappedWritableSingletonState;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class WrappedWritableStates
implements WritableStates {
    private final WritableStates delegate;
    private final Map<String, WrappedWritableKVState<?, ?>> writableKVStateMap = new HashMap();
    private final Map<String, WrappedWritableSingletonState<?>> writableSingletonStateMap = new HashMap();
    private final Map<String, WrappedWritableQueueState<?>> writableQueueStateMap = new HashMap();

    public WrappedWritableStates(@NonNull WritableStates delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
    }

    public boolean contains(@NonNull String stateKey) {
        return this.delegate.contains(stateKey);
    }

    @NonNull
    public Set<String> stateKeys() {
        return this.delegate.stateKeys();
    }

    @NonNull
    public <K, V> WritableKVState<K, V> get(@NonNull String stateKey) {
        return (WritableKVState)this.writableKVStateMap.computeIfAbsent(stateKey, s -> new WrappedWritableKVState(this.delegate.get(stateKey)));
    }

    @NonNull
    public <T> WritableSingletonState<T> getSingleton(@NonNull String stateKey) {
        return (WritableSingletonState)this.writableSingletonStateMap.computeIfAbsent(stateKey, s -> new WrappedWritableSingletonState(this.delegate.getSingleton(stateKey)));
    }

    @NonNull
    public <E> WritableQueueState<E> getQueue(@NonNull String stateKey) {
        return (WritableQueueState)this.writableQueueStateMap.computeIfAbsent(stateKey, s -> new WrappedWritableQueueState(this.delegate.getQueue(stateKey)));
    }

    public boolean isModified() {
        for (WrappedWritableKVState<?, ?> wrappedWritableKVState : this.writableKVStateMap.values()) {
            if (!wrappedWritableKVState.isModified()) continue;
            return true;
        }
        for (WrappedWritableQueueState wrappedWritableQueueState : this.writableQueueStateMap.values()) {
            if (!wrappedWritableQueueState.isModified()) continue;
            return true;
        }
        for (WrappedWritableSingletonState wrappedWritableSingletonState : this.writableSingletonStateMap.values()) {
            if (!wrappedWritableSingletonState.isModified()) continue;
            return true;
        }
        return false;
    }

    public void commit(boolean commitSingletons) {
        WritableStates writableStates;
        for (WrappedWritableKVState<?, ?> writableStates2 : this.writableKVStateMap.values()) {
            writableStates2.commit();
        }
        for (WrappedWritableQueueState wrappedWritableQueueState : this.writableQueueStateMap.values()) {
            wrappedWritableQueueState.commit();
        }
        if (commitSingletons) {
            for (WrappedWritableSingletonState wrappedWritableSingletonState : this.writableSingletonStateMap.values()) {
                wrappedWritableSingletonState.commit();
            }
        }
        if ((writableStates = this.delegate) instanceof CommittableWritableStates) {
            CommittableWritableStates terminalStates = (CommittableWritableStates)writableStates;
            terminalStates.commit();
        }
    }
}

