/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.throttle.ThrottleUsage;
import com.hedera.node.app.throttle.annotations.IngestThrottle;
import com.hedera.node.app.workflows.TransactionInfo;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.InstantSource;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SynchronizedThrottleAccumulator {
    private final InstantSource instantSource;
    private final ThrottleAccumulator frontendThrottle;
    @NonNull
    private Instant lastDecisionTime = Instant.EPOCH;

    @Inject
    public SynchronizedThrottleAccumulator(@NonNull InstantSource instantSource, @IngestThrottle @NonNull ThrottleAccumulator frontendThrottle) {
        this.instantSource = Objects.requireNonNull(instantSource);
        this.frontendThrottle = Objects.requireNonNull(frontendThrottle, "frontendThrottle must not be null");
    }

    public synchronized boolean shouldThrottle(@NonNull TransactionInfo txnInfo, @NonNull State state, @NonNull List<ThrottleUsage> throttleUsages) {
        Objects.requireNonNull(txnInfo);
        Objects.requireNonNull(state);
        Objects.requireNonNull(throttleUsages);
        this.setDecisionTime(this.instantSource.instant());
        return this.frontendThrottle.checkAndEnforceThrottle(txnInfo, this.lastDecisionTime, state, throttleUsages);
    }

    public synchronized boolean shouldThrottle(@NonNull HederaFunctionality queryFunction, @NonNull Query query, @NonNull State state, @Nullable AccountID queryPayerId) {
        Objects.requireNonNull(query);
        Objects.requireNonNull(queryFunction);
        this.setDecisionTime(this.instantSource.instant());
        return this.frontendThrottle.checkAndEnforceThrottle(queryFunction, this.lastDecisionTime, query, state, queryPayerId);
    }

    private void setDecisionTime(@NonNull Instant time) {
        this.lastDecisionTime = time.isBefore(this.lastDecisionTime) ? this.lastDecisionTime : time;
    }
}

