/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.tss;

import com.hedera.node.app.blocks.BlockHashSigner;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.hints.HintsService;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.TssConfig;
import com.hedera.node.config.types.StreamMode;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TssBlockHashSigner
implements BlockHashSigner {
    private static final Logger log = LogManager.getLogger(TssBlockHashSigner.class);
    public static final String SIGNER_READY_MSG = "TSS protocol ready to sign blocks";
    @Nullable
    private final HintsService hintsService;
    @Nullable
    private final HistoryService historyService;
    private boolean loggedReady = false;

    public TssBlockHashSigner(@NonNull HintsService hintsService, @NonNull HistoryService historyService, @NonNull ConfigProvider configProvider) {
        TssConfig tssConfig = (TssConfig)configProvider.getConfiguration().getConfigData(TssConfig.class);
        StreamMode streamMode = ((BlockStreamConfig)configProvider.getConfiguration().getConfigData(BlockStreamConfig.class)).streamMode();
        this.hintsService = tssConfig.hintsEnabled() && streamMode != StreamMode.RECORDS ? hintsService : null;
        this.historyService = tssConfig.historyEnabled() && streamMode != StreamMode.RECORDS ? historyService : null;
    }

    @Override
    public boolean isReady() {
        boolean answer;
        boolean bl = answer = !(this.hintsService != null && !this.hintsService.isReady() || this.historyService != null && !this.historyService.isReady());
        if (answer && !this.loggedReady) {
            log.info(SIGNER_READY_MSG);
            this.loggedReady = true;
        }
        return answer;
    }

    @Override
    public CompletableFuture<Bytes> signFuture(@NonNull Bytes blockHash) {
        Objects.requireNonNull(blockHash);
        if (!this.isReady()) {
            throw new IllegalStateException("TSS protocol not ready to sign block hash " + String.valueOf(blockHash));
        }
        CompletableFuture<Object> result = this.historyService == null ? (this.hintsService == null ? CompletableFuture.supplyAsync(() -> CommonUtils.noThrowSha384HashOf((Bytes)blockHash)) : this.hintsService.signFuture(blockHash)) : (this.hintsService == null ? CompletableFuture.supplyAsync(() -> CommonUtils.noThrowSha384HashOf((Bytes)blockHash)) : this.hintsService.signFuture(blockHash));
        return result;
    }

    @Override
    public long schemeId() {
        return this.hintsService == null ? 1L : this.hintsService.schemeId();
    }

    @Override
    public Bytes verificationKey() {
        return this.hintsService == null ? Bytes.EMPTY : this.hintsService.activeVerificationKeyOrThrow();
    }
}

