/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.collections;

import com.swirlds.config.api.Configuration;
import com.swirlds.merkledb.collections.AbstractLongList;
import com.swirlds.merkledb.utilities.MerkleDbFileUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLongArray;
import org.hiero.base.utility.MemoryUtils;

public final class LongListHeap
extends AbstractLongList<AtomicLongArray> {
    private ByteBuffer initReadBuffer;

    public LongListHeap(long capacity, Configuration configuration) {
        super(capacity, configuration);
    }

    public LongListHeap(int longsPerChunk, long capacity, long reservedBufferSize) {
        super(longsPerChunk, capacity, reservedBufferSize);
    }

    public LongListHeap(@NonNull Path file, long capacity, @NonNull Configuration configuration) throws IOException {
        super(file, capacity, configuration);
    }

    public LongListHeap(@NonNull Path path, int longsPerChunk, long capacity, long reservedBufferSize, Configuration configuration) throws IOException {
        super(path, longsPerChunk, capacity, reservedBufferSize, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readBodyFromFileChannelOnInit(String sourceFileName, FileChannel fileChannel, Configuration configuration) throws IOException {
        this.initReadBuffer = ByteBuffer.allocateDirect(this.memoryChunkSize).order(ByteOrder.nativeOrder());
        try {
            super.readBodyFromFileChannelOnInit(sourceFileName, fileChannel, configuration);
        }
        finally {
            MemoryUtils.closeDirectByteBuffer((ByteBuffer)this.initReadBuffer);
        }
    }

    @Override
    protected AtomicLongArray readChunkData(FileChannel fileChannel, int chunkIndex, int startIndex, int endIndex) throws IOException {
        AtomicLongArray chunk = this.createChunk();
        LongListHeap.readDataIntoBuffer(fileChannel, chunkIndex, startIndex, endIndex, this.initReadBuffer);
        int startOffset = startIndex * 8;
        int endOffset = endIndex * 8;
        this.initReadBuffer.position(startOffset);
        this.initReadBuffer.limit(endOffset);
        while (this.initReadBuffer.hasRemaining()) {
            int index = this.initReadBuffer.position() / 8;
            chunk.set(index, this.initReadBuffer.getLong());
        }
        return chunk;
    }

    @Override
    protected void putToChunk(AtomicLongArray chunk, int subIndex, long value) {
        chunk.set(subIndex, value);
    }

    @Override
    protected boolean putIfEqual(AtomicLongArray chunk, int subIndex, long oldValue, long newValue) {
        return chunk.compareAndSet(subIndex, oldValue, newValue);
    }

    @Override
    protected void writeLongsData(FileChannel fc) throws IOException {
        ByteBuffer tempBuffer = ByteBuffer.allocateDirect(0x100000);
        tempBuffer.order(ByteOrder.nativeOrder());
        LongBuffer tempLongBuffer = tempBuffer.asLongBuffer();
        for (long i = this.minValidIndex.get(); i < this.size(); ++i) {
            if (!tempLongBuffer.hasRemaining()) {
                tempBuffer.clear();
                MerkleDbFileUtils.completelyWrite(fc, tempBuffer);
                tempLongBuffer.clear();
            }
            tempLongBuffer.put(this.get(i, 0L));
        }
        if (tempLongBuffer.position() > 0) {
            tempBuffer.position(0);
            tempBuffer.limit(tempLongBuffer.position() * 8);
            MerkleDbFileUtils.completelyWrite(fc, tempBuffer);
        }
    }

    @Override
    protected long lookupInChunk(@NonNull AtomicLongArray chunk, long subIndex) {
        return chunk.get(Math.toIntExact(subIndex));
    }

    @Override
    protected void partialChunkCleanup(@NonNull AtomicLongArray atomicLongArray, boolean leftSide, long entriesToCleanUp) {
        if (leftSide) {
            int i = 0;
            while ((long)i < entriesToCleanUp) {
                atomicLongArray.set(i, 0L);
                ++i;
            }
        } else {
            for (int i = Math.toIntExact((long)atomicLongArray.length() - entriesToCleanUp); i < atomicLongArray.length(); ++i) {
                atomicLongArray.set(i, 0L);
            }
        }
    }

    @Override
    protected AtomicLongArray createChunk() {
        return new AtomicLongArray(this.longsPerChunk);
    }
}

