/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.hedera.node.app.hapi.fees.usage.QueryUsage;
import com.hedera.node.app.hapi.fees.usage.crypto.entities.CryptoEntitySizes;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Query;
import java.nio.charset.StandardCharsets;

public final class CryptoGetInfoUsage
extends QueryUsage {
    private CryptoGetInfoUsage(Query query) {
        super(query.getCryptoGetInfo().getHeader().getResponseType());
        this.addTb(24L);
        this.addRb(CryptoEntitySizes.CRYPTO_ENTITY_SIZES.fixedBytesInAccountRepr());
    }

    public static CryptoGetInfoUsage newEstimate(Query query) {
        return new CryptoGetInfoUsage(query);
    }

    public CryptoGetInfoUsage givenCurrentKey(Key key) {
        this.addRb(FeeBuilder.getAccountKeyStorageSize((Key)key));
        return this;
    }

    public CryptoGetInfoUsage givenCurrentMemo(String memo) {
        this.addRb(memo.getBytes(StandardCharsets.UTF_8).length);
        return this;
    }

    public CryptoGetInfoUsage givenCurrentTokenAssocs(int count) {
        this.addRb((long)count * CryptoEntitySizes.CRYPTO_ENTITY_SIZES.bytesInTokenAssocRepr());
        return this;
    }

    public CryptoGetInfoUsage givenCurrentlyUsingProxy() {
        this.addRb(24L);
        return this;
    }
}

