/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.node.app.fees.ExchangeRateInfoImpl;
import com.hedera.node.app.spi.fees.ExchangeRateInfo;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.util.FileUtilities;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.RatesConfig;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.State;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Objects;
import java.util.stream.LongStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public final class ExchangeRateManager {
    private static final Logger log = LogManager.getLogger(ExchangeRateManager.class);
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    private final ConfigProvider configProvider;
    private ExchangeRateInfo currentExchangeRateInfo;
    private ExchangeRateSet midnightRates;

    @Inject
    public ExchangeRateManager(@NonNull ConfigProvider configProvider) {
        this.configProvider = Objects.requireNonNull(configProvider, "configProvider must not be null");
    }

    public void init(@NonNull State state, @NonNull Bytes bytes) {
        Objects.requireNonNull(state, "state must not be null");
        Objects.requireNonNull(bytes, "bytes must not be null");
        this.systemUpdate(bytes);
        this.midnightRates = (ExchangeRateSet)state.getReadableStates("FeeService").getSingleton("MIDNIGHT_RATES").get();
        Objects.requireNonNull(this.midnightRates, "an initialized state must have a midnight rates set");
        log.info("Initializing exchange rates with midnight rates {} and active rates {}", (Object)this.midnightRates, (Object)this.currentExchangeRateInfo.exchangeRates());
    }

    public void update(@NonNull Bytes bytes, @NonNull AccountID payerId) {
        Objects.requireNonNull(payerId, "payerId must not be null");
        this.internalUpdate(bytes, payerId);
    }

    public void systemUpdate(@NonNull Bytes bytes) {
        this.internalUpdate(bytes, null);
    }

    private void internalUpdate(@NonNull Bytes bytes, @Nullable AccountID payerId) {
        int limitPercent;
        ExchangeRateSet proposedRates;
        Objects.requireNonNull(bytes, "bytes must not be null");
        try {
            proposedRates = (ExchangeRateSet)ExchangeRateSet.PROTOBUF.parse(bytes.toReadableSequentialData());
        }
        catch (ParseException e) {
            throw new HandleException(ResponseCodeEnum.INVALID_EXCHANGE_RATE_FILE);
        }
        if (!(proposedRates.hasCurrentRate() && proposedRates.currentRateOrThrow().hasExpirationTime() && proposedRates.hasNextRate())) {
            throw new HandleException(ResponseCodeEnum.INVALID_EXCHANGE_RATE_FILE);
        }
        RatesConfig ratesConfig = (RatesConfig)this.configProvider.getConfiguration().getConfigData(RatesConfig.class);
        AccountsConfig accountsConfig = (AccountsConfig)this.configProvider.getConfiguration().getConfigData(AccountsConfig.class);
        boolean isSuperUser = this.isSuperUser(payerId, accountsConfig);
        if (!isSuperUser && !ExchangeRateManager.isNormalIntradayChange(this.midnightRates, proposedRates, limitPercent = ratesConfig.intradayChangeLimitPercent())) {
            throw new HandleException(ResponseCodeEnum.EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED);
        }
        this.currentExchangeRateInfo = new ExchangeRateInfoImpl(proposedRates);
        if (this.isAdminUser(payerId, accountsConfig)) {
            this.midnightRates = proposedRates;
        }
    }

    private boolean isSuperUser(@NonNull AccountID accountID, AccountsConfig accountsConfig) {
        if (accountID == null) {
            return true;
        }
        if (!accountID.hasAccountNum()) {
            return false;
        }
        long num = accountID.accountNumOrThrow();
        return num == accountsConfig.treasury() || num == accountsConfig.systemAdmin();
    }

    private boolean isAdminUser(@NonNull AccountID accountID, AccountsConfig accountsConfig) {
        if (accountID == null) {
            return true;
        }
        if (!accountID.hasAccountNum()) {
            return false;
        }
        long num = accountID.accountNumOrThrow();
        return num == accountsConfig.systemAdmin();
    }

    public void updateMidnightRates(@NonNull State state) {
        this.midnightRates = this.currentExchangeRateInfo.exchangeRates();
        WritableSingletonState singleton = state.getWritableStates("FeeService").getSingleton("MIDNIGHT_RATES");
        singleton.put((Object)this.midnightRates);
        log.info("Updated midnight rates to {}", (Object)this.midnightRates);
    }

    @NonNull
    public ExchangeRateSet exchangeRates() {
        return this.currentExchangeRateInfo.exchangeRates();
    }

    @NonNull
    public ExchangeRate activeRate(@NonNull Instant consensusTime) {
        return this.currentExchangeRateInfo.activeRate(consensusTime);
    }

    @NonNull
    public ExchangeRateInfo exchangeRateInfo(@NonNull State state) {
        ExchangeRateSet exchangeRates;
        HederaConfig hederaConfig = (HederaConfig)this.configProvider.getConfiguration().getConfigData(HederaConfig.class);
        long shardNum = hederaConfig.shard();
        long realmNum = hederaConfig.realm();
        long fileNum = ((FilesConfig)this.configProvider.getConfiguration().getConfigData(FilesConfig.class)).exchangeRates();
        FileID fileID = FileID.newBuilder().shardNum(shardNum).realmNum(realmNum).fileNum(fileNum).build();
        Bytes bytes = FileUtilities.getFileContent(state, fileID);
        try {
            exchangeRates = (ExchangeRateSet)ExchangeRateSet.PROTOBUF.parse(bytes.toReadableSequentialData());
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
        return new ExchangeRateInfoImpl(exchangeRates);
    }

    private static boolean isNormalIntradayChange(@NonNull ExchangeRateSet midnightRates, @NonNull ExchangeRateSet proposedRates, int limitPercent) {
        return ExchangeRateManager.canonicalTest(limitPercent, midnightRates.currentRate().centEquiv(), midnightRates.currentRate().hbarEquiv(), proposedRates.currentRate().centEquiv(), proposedRates.currentRate().hbarEquiv()) && ExchangeRateManager.canonicalTest(limitPercent, midnightRates.nextRate().centEquiv(), midnightRates.nextRate().hbarEquiv(), proposedRates.nextRate().centEquiv(), proposedRates.nextRate().hbarEquiv());
    }

    private static boolean canonicalTest(long bound, long oldC, long oldH, long newC, long newH) {
        BigInteger b100 = BigInteger.valueOf(bound).add(ONE_HUNDRED);
        BigInteger oC = BigInteger.valueOf(oldC);
        BigInteger oH = BigInteger.valueOf(oldH);
        BigInteger nC = BigInteger.valueOf(newC);
        BigInteger nH = BigInteger.valueOf(newH);
        return LongStream.of(bound, oldC, oldH, newC, newH).allMatch(i -> i > 0L) && oC.multiply(nH).multiply(b100).subtract(nC.multiply(oH).multiply(ONE_HUNDRED)).signum() >= 0 && oH.multiply(nC).multiply(b100).subtract(nH.multiply(oC).multiply(ONE_HUNDRED)).signum() >= 0;
    }

    public long getTinybarsFromTinycents(long amount, @NonNull Instant consensusTime) {
        ExchangeRate rate = this.activeRate(consensusTime);
        return ExchangeRateManager.getAFromB(amount, rate.hbarEquiv(), rate.centEquiv());
    }

    private static long getAFromB(long bAmount, int aEquiv, int bEquiv) {
        BigInteger aMultiplier = BigInteger.valueOf(aEquiv);
        BigInteger bDivisor = BigInteger.valueOf(bEquiv);
        return BigInteger.valueOf(bAmount).multiply(aMultiplier).divide(bDivisor).longValueExact();
    }
}

