/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.keys.KeyComparator;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.schedule.ScheduleStreamBuilder;
import com.hedera.node.app.service.schedule.impl.handlers.HandlerUtility;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.signatures.VerificationAssistant;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.TransactionKeys;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;

public abstract class AbstractScheduleHandler {
    static final Comparator<Key> KEY_COMPARATOR = new KeyComparator();
    private final FeeCharging customFeeCharging;

    protected AbstractScheduleHandler(@NonNull FeeCharging customFeeCharging) {
        this.customFeeCharging = Objects.requireNonNull(customFeeCharging);
    }

    @NonNull
    protected TransactionKeys getTransactionKeysOrThrow(@NonNull Schedule schedule, @NonNull TransactionKeysFn fn) throws HandleException {
        Objects.requireNonNull(schedule);
        Objects.requireNonNull(fn);
        try {
            return this.getRequiredKeys(schedule, fn);
        }
        catch (PreCheckException e) {
            throw new HandleException(e.responseCode());
        }
    }

    @NonNull
    protected TransactionKeys getRequiredKeys(@NonNull Schedule schedule, @NonNull TransactionKeysFn fn) throws PreCheckException {
        Objects.requireNonNull(schedule);
        Objects.requireNonNull(fn);
        TransactionBody body = HandlerUtility.childAsOrdinary(schedule);
        AccountID creatorId = schedule.originalCreateTransactionOrThrow().transactionIDOrThrow().accountIDOrThrow();
        AccountID payerId = schedule.payerAccountIdOrElse(creatorId);
        TransactionKeys transactionKeys = fn.apply(body, payerId);
        if (!transactionKeys.requiredHollowAccounts().isEmpty()) {
            throw new PreCheckException(ResponseCodeEnum.UNRESOLVABLE_REQUIRED_SIGNERS);
        }
        return transactionKeys;
    }

    @NonNull
    protected List<Key> allRequiredKeys(@NonNull TransactionKeys keys) {
        ArrayList<Key> all = new ArrayList<Key>();
        all.add(keys.payerKey());
        all.addAll(keys.requiredNonPayerKeys());
        return all;
    }

    @NonNull
    protected static List<Key> newSignatories(@NonNull SortedSet<Key> authorizingKeys, @NonNull List<Key> signatories, @NonNull List<Key> requiredKeys) {
        Objects.requireNonNull(authorizingKeys);
        Objects.requireNonNull(signatories);
        Objects.requireNonNull(requiredKeys);
        ConcurrentSkipListSet<Key> newSignatories = new ConcurrentSkipListSet<Key>(KEY_COMPARATOR);
        newSignatories.addAll(signatories);
        requiredKeys.forEach(k -> AbstractScheduleHandler.accumulateNewSignatories(newSignatories, authorizingKeys, k));
        authorizingKeys.forEach(key -> {
            if (AbstractScheduleHandler.isNumericContractIdKey(key)) {
                newSignatories.add((Key)key);
            }
        });
        return new ArrayList<Key>(newSignatories);
    }

    @NonNull
    protected Schedule getValidated(@NonNull ScheduleID scheduleId, @NonNull ReadableScheduleStore scheduleStore, boolean isLongTermEnabled) throws PreCheckException {
        Objects.requireNonNull(scheduleId);
        Objects.requireNonNull(scheduleStore);
        Schedule schedule = scheduleStore.get(scheduleId);
        ResponseCodeEnum validationResult = this.validate(schedule, null, isLongTermEnabled);
        if (validationResult == ResponseCodeEnum.OK) {
            return Objects.requireNonNull(schedule);
        }
        throw new PreCheckException(validationResult);
    }

    @NonNull
    protected ResponseCodeEnum validate(@Nullable Schedule schedule, @Nullable Instant consensusNow, boolean isLongTermEnabled) {
        if (schedule == null) {
            return ResponseCodeEnum.INVALID_SCHEDULE_ID;
        }
        if (!schedule.hasScheduledTransaction()) {
            return ResponseCodeEnum.INVALID_TRANSACTION;
        }
        if (schedule.executed()) {
            return ResponseCodeEnum.SCHEDULE_ALREADY_EXECUTED;
        }
        if (schedule.deleted()) {
            return ResponseCodeEnum.SCHEDULE_ALREADY_DELETED;
        }
        long expiration = schedule.calculatedExpirationSecond();
        Instant calculatedExpiration = expiration != Schedule.DEFAULT.calculatedExpirationSecond() ? Instant.ofEpochSecond(expiration) : Instant.MAX;
        Instant effectiveNow = Objects.requireNonNullElse(consensusNow, Instant.MIN);
        if (calculatedExpiration.getEpochSecond() >= effectiveNow.getEpochSecond()) {
            return ResponseCodeEnum.OK;
        }
        return isLongTermEnabled ? ResponseCodeEnum.SCHEDULE_PENDING_EXPIRATION : ResponseCodeEnum.INVALID_SCHEDULE_ID;
    }

    protected boolean isMaybeExecutable(@NonNull ResponseCodeEnum validationResult) {
        return validationResult == ResponseCodeEnum.OK || validationResult == ResponseCodeEnum.SUCCESS || validationResult == ResponseCodeEnum.SCHEDULE_PENDING_EXPIRATION;
    }

    protected boolean tryToExecuteSchedule(@NonNull HandleContext context, @NonNull Schedule schedule, @NonNull List<Key> requiredKeys, @NonNull ResponseCodeEnum validationResult, boolean isLongTermEnabled) {
        boolean isExpired;
        Objects.requireNonNull(context);
        Objects.requireNonNull(schedule);
        Objects.requireNonNull(requiredKeys);
        Objects.requireNonNull(validationResult);
        ReadableAccountStore accountStore = (ReadableAccountStore)context.storeFactory().readableStore(ReadableAccountStore.class);
        Predicate<Key> simpleKeyVerifier = AbstractScheduleHandler.simpleKeyVerifierFrom(accountStore, schedule.signatories());
        VerificationAssistant callback = (k, ignore) -> simpleKeyVerifier.test((Key)k);
        HashSet<Key> remainingKeys = new HashSet<Key>(requiredKeys);
        remainingKeys.removeIf(k -> context.keyVerifier().verificationFor(k, callback).passed());
        boolean bl = isExpired = validationResult == ResponseCodeEnum.SCHEDULE_PENDING_EXPIRATION;
        if (this.canExecute(schedule, remainingKeys, isExpired, isLongTermEnabled)) {
            TransactionBody body = HandlerUtility.childAsOrdinary(schedule);
            ((ScheduleStreamBuilder)context.dispatch(DispatchOptions.subDispatch((AccountID)schedule.payerAccountIdOrThrow(), (TransactionBody)body, simpleKeyVerifier, Collections.emptySet(), ScheduleStreamBuilder.class, (DispatchOptions.StakingRewards)DispatchOptions.StakingRewards.ON, (DispatchOptions.UsePresetTxnId)DispatchOptions.UsePresetTxnId.NO, (FeeCharging)this.customFeeCharging, (DispatchOptions.PropagateFeeChargingStrategy)DispatchOptions.PropagateFeeChargingStrategy.NO))).scheduleRef(schedule.scheduleId());
            ((ScheduleStreamBuilder)context.savepointStack().getBaseBuilder(ScheduleStreamBuilder.class)).scheduledTransactionID(body.transactionID());
            return true;
        }
        return false;
    }

    public static Predicate<Key> simpleKeyVerifierFrom(@NonNull ReadableAccountStore accountStore, @NonNull List<Key> signatories) {
        HashSet cryptoSigs = new HashSet();
        HashSet contractIdSigs = new HashSet();
        HashSet delegatableContractIdSigs = new HashSet();
        signatories.forEach(k -> {
            switch ((Key.KeyOneOfType)k.key().kind()) {
                case ED25519: 
                case ECDSA_SECP256K1: {
                    cryptoSigs.add(k);
                    break;
                }
                case CONTRACT_ID: {
                    contractIdSigs.add(k.contractIDOrThrow());
                    break;
                }
                case DELEGATABLE_CONTRACT_ID: {
                    delegatableContractIdSigs.add(k.delegatableContractIdOrThrow());
                    break;
                }
            }
        });
        return key -> switch ((Key.KeyOneOfType)key.key().kind()) {
            case Key.KeyOneOfType.ED25519, Key.KeyOneOfType.ECDSA_SECP256K1 -> cryptoSigs.contains(key);
            case Key.KeyOneOfType.CONTRACT_ID -> AbstractScheduleHandler.isAuthorized(key.contractIDOrThrow(), accountStore, contractIdSigs, Collections.emptySet());
            case Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID -> AbstractScheduleHandler.isAuthorized(key.delegatableContractIdOrThrow(), accountStore, delegatableContractIdSigs, contractIdSigs);
            default -> false;
        };
    }

    @NonNull
    protected static Schedule markedExecuted(@NonNull Schedule schedule, @NonNull Instant consensusNow) {
        return schedule.copyBuilder().executed(true).resolutionTime(HapiUtils.asTimestamp((Instant)consensusNow)).build();
    }

    private boolean canExecute(@NonNull Schedule schedule, @NonNull Set<Key> remainingKeys, boolean isExpired, boolean isLongTermEnabled) {
        if (!remainingKeys.isEmpty()) {
            return false;
        }
        if (!isLongTermEnabled) {
            return true;
        }
        return schedule.waitForExpiry() == isExpired;
    }

    private static void accumulateNewSignatories(@NonNull Set<Key> signatories, @NonNull Set<Key> signingCryptoKeys, @NonNull Key key) {
        switch ((Key.KeyOneOfType)key.key().kind()) {
            case ED25519: 
            case ECDSA_SECP256K1: {
                if (!signingCryptoKeys.contains(key)) break;
                signatories.add(key);
                break;
            }
            case KEY_LIST: {
                key.keyListOrThrow().keys().forEach(k -> AbstractScheduleHandler.accumulateNewSignatories(signatories, signingCryptoKeys, k));
                break;
            }
            case THRESHOLD_KEY: {
                key.thresholdKeyOrThrow().keysOrThrow().keys().forEach(k -> AbstractScheduleHandler.accumulateNewSignatories(signatories, signingCryptoKeys, k));
            }
        }
    }

    private static boolean isNumericContractIdKey(@NonNull Key key) {
        return key.hasContractID() && key.contractIDOrThrow().hasContractNum() || key.hasDelegatableContractId() && key.delegatableContractIdOrThrow().hasContractNum();
    }

    private static boolean isAuthorized(@NonNull ContractID contractId, @NonNull ReadableAccountStore accountStore, @NonNull Set<ContractID> firstAuthorized, @NonNull Set<ContractID> secondAuthorized) {
        AccountID accountId;
        ContractID effectiveId = ContractID.DEFAULT;
        if (contractId.hasContractNum()) {
            effectiveId = contractId;
        } else if (contractId.hasEvmAddress() && (accountId = accountStore.getAccountIDByAlias(contractId.shardNum(), contractId.realmNum(), contractId.evmAddressOrThrow())) != null) {
            effectiveId = ContractID.newBuilder().shardNum(accountId.shardNum()).realmNum(accountId.realmNum()).contractNum(accountId.accountNumOrThrow().longValue()).build();
        }
        return firstAuthorized.contains(effectiveId) || secondAuthorized.contains(effectiveId);
    }

    @FunctionalInterface
    protected static interface TransactionKeysFn {
        public TransactionKeys apply(@NonNull TransactionBody var1, @NonNull AccountID var2) throws PreCheckException;
    }
}

