/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.util.Objects;
import org.hiero.consensus.model.roster.AddressBook;

public class ApplicationDefinition {
    private final String swirldName;
    private final String[] appParameters;
    private final String mainClassName;
    private final Path appJarPath;
    private final AddressBook configAddressBook;

    public ApplicationDefinition(@NonNull String swirldName, @NonNull String[] appParameters, @NonNull String mainClassName, @NonNull Path appJarPath, @NonNull AddressBook configAddressBook) {
        this.swirldName = Objects.requireNonNull(swirldName, "swirldName must not be null");
        this.appParameters = Objects.requireNonNull(appParameters, "appParameters must not be null");
        this.mainClassName = Objects.requireNonNull(mainClassName, "mainClassName must not be null");
        this.appJarPath = Objects.requireNonNull(appJarPath, "appJarPath must not be null");
        this.configAddressBook = Objects.requireNonNull(configAddressBook, "configAddressBook must not be null");
    }

    public String getSwirldName() {
        return this.swirldName;
    }

    public String[] getAppParameters() {
        return this.appParameters;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public String getApplicationName() {
        return this.mainClassName.substring(0, this.mainClassName.length() - 4);
    }

    public Path getAppJarPath() {
        return this.appJarPath;
    }

    public AddressBook getConfigAddressBook() {
        return this.configAddressBook;
    }
}

