/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.metrics;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.metrics.api.IntegerGauge;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.roster.RosterUtils;

public class IssMetrics {
    private final Roster roster;
    private int issCount;
    private long highestRound = Long.MIN_VALUE;
    private final IntegerGauge issCountGauge;
    private long issWeight;
    private final LongGauge issWeightGage;
    private final Map<NodeId, IssStatus> issDataByNode = new HashMap<NodeId, IssStatus>();

    public IssMetrics(@NonNull Metrics metrics, @NonNull Roster roster) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        this.roster = Objects.requireNonNull(roster, "roster must not be null");
        this.issCountGauge = (IntegerGauge)metrics.getOrCreate((MetricConfig)new IntegerGauge.Config("internal", "issCount").withDescription("the number of nodes that currently disagree with the consensus hash"));
        this.issWeightGage = (LongGauge)metrics.getOrCreate((MetricConfig)new LongGauge.Config("internal", "issWeight").withDescription("the amount of weight tied up by ISS events"));
        for (RosterEntry node : roster.rosterEntries()) {
            this.issDataByNode.put(NodeId.of((long)node.nodeId()), new IssStatus());
        }
    }

    public int getIssCount() {
        return this.issCount;
    }

    public long getIssWeight() {
        return this.issWeight;
    }

    public void stateHashValidityObserver(@NonNull Long round, @NonNull NodeId nodeId, @NonNull Hash nodeHash, @NonNull Hash consensusHash) {
        Objects.requireNonNull(round, "round must not be null");
        Objects.requireNonNull(nodeId, "nodeId must not be null");
        Objects.requireNonNull(nodeHash, "nodeHash must not be null");
        Objects.requireNonNull(consensusHash, "consensusHash must not be null");
        boolean hasIss = !nodeHash.equals((Object)consensusHash);
        IssStatus issStatus = this.issDataByNode.get(nodeId);
        if (issStatus == null) {
            throw new IllegalArgumentException("Node " + String.valueOf(nodeId) + " is not being tracked");
        }
        this.highestRound = Math.max(this.highestRound, round);
        if (issStatus.getRound() >= round) {
            return;
        }
        issStatus.setRound(round);
        if (issStatus.hasIss() != hasIss) {
            long weight = RosterUtils.getRosterEntry((Roster)this.roster, (long)nodeId.id()).weight();
            if (hasIss) {
                ++this.issCount;
                this.issWeight += weight;
            } else {
                --this.issCount;
                this.issWeight -= weight;
            }
            this.issCountGauge.set(this.issCount);
            this.issWeightGage.set(this.issWeight);
            issStatus.setHasIss(hasIss);
        }
    }

    public void catastrophicIssObserver(long round) {
        if (round <= this.highestRound) {
            return;
        }
        this.highestRound = round;
        for (IssStatus status : this.issDataByNode.values()) {
            status.setHasIss(true);
            status.setRound(round);
        }
        this.issCount = this.roster.rosterEntries().size();
        this.issWeight = RosterUtils.computeTotalWeight((Roster)this.roster);
        this.issCountGauge.set(this.issCount);
        this.issWeightGage.set(this.issWeight);
    }

    private static class IssStatus {
        private boolean hasIss = false;
        private long round = Long.MIN_VALUE;

        private IssStatus() {
        }

        public boolean hasIss() {
            return this.hasIss;
        }

        public void setHasIss(boolean hasIss) {
            this.hasIss = hasIss;
        }

        public long getRound() {
            return this.round;
        }

        public void setRound(long round) {
            this.round = round;
        }
    }
}

