/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.editor;

import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteIterator;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.editor.StateEditor;
import com.swirlds.platform.state.editor.StateEditorOperation;
import com.swirlds.platform.state.editor.StateEditorRoot;
import com.swirlds.platform.state.editor.StateEditorUtils;
import com.swirlds.platform.state.signed.ReservedSignedState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Hashable;
import picocli.CommandLine;

@CommandLine.Command(name="rm", mixinStandardHelpOptions=true, description={"Remove a node, replacing it with null."})
@SubcommandOf(value=StateEditorRoot.class)
public class StateEditorRm
extends StateEditorOperation {
    private static final Logger logger = LogManager.getLogger(StateEditorRm.class);
    private String path = "";

    @CommandLine.Parameters(arity="0..1", description={"The route of the node to remove."})
    private void setPath(String path) {
        this.path = path;
    }

    @Override
    public void run() {
        StateEditor.ParentInfo parentInfo = this.getStateEditor().getParentInfo(this.path);
        MerkleRoute destinationRoute = parentInfo.target();
        MerkleInternal parent = parentInfo.parent();
        int indexInParent = parentInfo.indexInParent();
        try (ReservedSignedState reservedSignedState = this.getStateEditor().getState("StateEditorRm.run()");){
            MerkleNodeState state = reservedSignedState.get().getState();
            MerkleNode child = state.getRoot().getNodeAtRoute(destinationRoute);
            if (logger.isInfoEnabled(LogMarker.CLI.getMarker())) {
                logger.info(LogMarker.CLI.getMarker(), "Removing {} from parent {}", (Object)StateEditorUtils.formatNode(child), (Object)StateEditorUtils.formatParent((MerkleNode)parent, indexInParent));
            }
            parent.setChild(indexInParent, null);
            new MerkleRouteIterator(state.getRoot(), parent.getRoute()).forEachRemaining(Hashable::invalidateHash);
        }
    }
}

