/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SStoreOperation
extends AbstractOperation {
    public static final long FRONTIER_MINIMUM = 0L;
    public static final long EIP_1706_MINIMUM = 2300L;
    protected static final Operation.OperationResult ILLEGAL_STATE_CHANGE = new Operation.OperationResult(0L, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
    private final long minimumGasRemaining;

    public SStoreOperation(GasCalculator gasCalculator, long minimumGasRemaining) {
        super(85, "SSTORE", 2, 0, gasCalculator);
        this.minimumGasRemaining = minimumGasRemaining;
    }

    public long getMinimumGasRemaining() {
        return this.minimumGasRemaining;
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        UInt256 key = UInt256.fromBytes((Bytes)frame.popStackItem());
        UInt256 newValue = UInt256.fromBytes((Bytes)frame.popStackItem());
        MutableAccount account = frame.getWorldUpdater().getAccount(frame.getRecipientAddress());
        if (account == null) {
            return ILLEGAL_STATE_CHANGE;
        }
        Address address = account.getAddress();
        boolean slotIsWarm = frame.warmUpStorage(address, (Bytes32)key);
        Supplier currentValueSupplier = Suppliers.memoize(() -> account.getStorageValue(key));
        Supplier originalValueSupplier = Suppliers.memoize(() -> account.getOriginalStorageValue(key));
        long cost = this.gasCalculator().calculateStorageCost(newValue, (java.util.function.Supplier<UInt256>)currentValueSupplier, (java.util.function.Supplier<UInt256>)originalValueSupplier) + (slotIsWarm ? 0L : this.gasCalculator().getColdSloadCost());
        long remainingGas = frame.getRemainingGas();
        if (frame.isStatic()) {
            return new Operation.OperationResult(remainingGas, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (remainingGas < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        if (remainingGas <= this.minimumGasRemaining) {
            return new Operation.OperationResult(this.minimumGasRemaining, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        frame.incrementGasRefund(this.gasCalculator().calculateStorageRefundAmount(newValue, (java.util.function.Supplier<UInt256>)currentValueSupplier, (java.util.function.Supplier<UInt256>)originalValueSupplier));
        account.setStorageValue(key, newValue);
        frame.storageWasUpdated(key, (Bytes)newValue);
        return new Operation.OperationResult(cost, null);
    }
}

