/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKeyValidation;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.TokenUpdateUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenRelationStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseTokenHandler;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.util.TokenKey;
import com.hedera.node.app.service.token.impl.validators.TokenUpdateValidator;
import com.hedera.node.app.service.token.records.TokenUpdateStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.validation.Validations;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hederahashgraph.api.proto.java.FeeData;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenUpdateHandler
extends BaseTokenHandler
implements TransactionHandler {
    private static final AccountID ZERO_ACCOUNT_ID = AccountID.newBuilder().accountNum(0L).build();
    private final TokenUpdateValidator tokenUpdateValidator;

    @Inject
    public TokenUpdateHandler(@NonNull TokenUpdateValidator tokenUpdateValidator) {
        this.tokenUpdateValidator = tokenUpdateValidator;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        TokenUpdateTransactionBody op = txn.tokenUpdateOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasToken(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        for (TokenKey tokenKey : TOKEN_KEYS) {
            Key key;
            if (!tokenKey.isPresentInUpdate(op) || AttributeValidator.isKeyRemoval((Key)(key = tokenKey.getFromUpdate(op)))) continue;
            PreCheckException.validateTruePreCheck((boolean)KeyUtils.isValid((Key)key), (ResponseCodeEnum)tokenKey.invalidKeyStatus());
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenUpdateTransactionBody op = context.body().tokenUpdateOrThrow();
        Token token = ((ReadableTokenStore)context.createStore(ReadableTokenStore.class)).get(op.tokenOrThrow());
        Validations.mustExist((Object)token, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        this.addRequiredSigners(context, op, token);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenUpdateTransactionBody op = txn.tokenUpdateOrThrow();
        TokenID tokenId = op.tokenOrThrow();
        TokenUpdateStreamBuilder recordBuilder = (TokenUpdateStreamBuilder)context.savepointStack().getBaseBuilder(TokenUpdateStreamBuilder.class);
        TokenUpdateValidator.ValidationResult validationResult = this.tokenUpdateValidator.validateSemantics(context, op);
        Token token = validationResult.token();
        ExpiryMeta resolvedExpiry = validationResult.resolvedExpiryMeta();
        StoreFactory storeFactory = context.storeFactory();
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        WritableTokenRelationStore tokenRelStore = (WritableTokenRelationStore)storeFactory.writableStore(WritableTokenRelationStore.class);
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        Configuration config = context.configuration();
        if (op.hasTreasury() && this.isHapiCallOrNonZeroTreasuryAccount(txn.hasTransactionID(), op)) {
            AccountID existingTreasury = token.treasuryAccountIdOrThrow();
            AccountID newTreasury = op.treasuryOrThrow();
            Account newTreasuryAccount = TokenHandlerHelper.getIfUsable(newTreasury, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
            TokenRelation newTreasuryRel = tokenRelStore.get(newTreasury, tokenId);
            if (newTreasuryRel == null) {
                TokenRelation newRelation = this.autoAssociate(newTreasuryAccount.accountIdOrThrow(), token, accountStore, tokenRelStore, config);
                recordBuilder.addAutomaticTokenAssociation(TokenUpdateHandler.asTokenAssociation(newRelation.tokenId(), newRelation.accountId()));
                newTreasuryAccount = Objects.requireNonNull(accountStore.get(newTreasury));
            }
            if (!newTreasury.equals((Object)existingTreasury)) {
                Account existingTreasuryAccount = TokenHandlerHelper.getIfUsable(existingTreasury, accountStore, context.expiryValidator(), ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
                this.updateTreasuryTitles(existingTreasuryAccount, newTreasuryAccount, token, accountStore, tokenRelStore);
                this.transferTokensToNewTreasury(existingTreasury, newTreasury, token, tokenRelStore, accountStore);
            }
        }
        Token.Builder tokenBuilder = this.customizeToken(token, resolvedExpiry, op, txn.hasTransactionID());
        tokenStore.put(tokenBuilder.build());
        recordBuilder.tokenType(token.tokenType());
    }

    private void transferTokensToNewTreasury(AccountID oldTreasury, AccountID newTreasury, Token token, WritableTokenRelationStore tokenRelStore, WritableAccountStore accountStore) {
        TokenID tokenId = token.tokenIdOrThrow();
        TokenRelation oldTreasuryRel = TokenHandlerHelper.getIfUsable(oldTreasury, tokenId, tokenRelStore);
        TokenRelation newTreasuryRel = TokenHandlerHelper.getIfUsable(newTreasury, tokenId, tokenRelStore);
        if (oldTreasuryRel.balance() > 0L) {
            this.validateFrozenAndKey(oldTreasuryRel);
            this.validateFrozenAndKey(newTreasuryRel);
            if (token.tokenType().equals((Object)TokenType.FUNGIBLE_COMMON)) {
                this.transferFungibleTokensToTreasury(oldTreasuryRel, newTreasuryRel, tokenRelStore, accountStore);
            } else {
                HandleException.validateTrue((newTreasuryRel.balance() == 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES);
                this.changeOwnerToNewTreasury(oldTreasuryRel, newTreasuryRel, tokenRelStore, accountStore);
            }
        }
    }

    private void transferFungibleTokensToTreasury(@NonNull TokenRelation fromTreasuryRel, @NonNull TokenRelation toTreasuryRel, WritableTokenRelationStore tokenRelStore, WritableAccountStore accountStore) {
        long adjustment = fromTreasuryRel.balance();
        Account fromTreasury = Objects.requireNonNull(accountStore.getAccountById(fromTreasuryRel.accountIdOrThrow()));
        Account toTreasury = Objects.requireNonNull(accountStore.getAccountById(toTreasuryRel.accountIdOrThrow()));
        this.adjustBalance(fromTreasuryRel, fromTreasury, -adjustment, tokenRelStore, accountStore);
        this.adjustBalance(toTreasuryRel, toTreasury, adjustment, tokenRelStore, accountStore);
    }

    private void changeOwnerToNewTreasury(TokenRelation fromTreasuryRel, TokenRelation toTreasuryRel, WritableTokenRelationStore tokenRelStore, WritableAccountStore accountStore) {
        Account fromTreasury = accountStore.getAccountById(fromTreasuryRel.accountId());
        Account toTreasury = accountStore.getAccountById(toTreasuryRel.accountId());
        long fromRelBalance = fromTreasuryRel.balance();
        long toRelBalance = toTreasuryRel.balance();
        long fromNftsOwned = fromTreasury.numberOwnedNfts();
        long toNftsOwned = toTreasury.numberOwnedNfts();
        Account.Builder fromTreasuryCopy = fromTreasury.copyBuilder();
        Account.Builder toTreasuryCopy = toTreasury.copyBuilder();
        TokenRelation.Builder fromRelCopy = fromTreasuryRel.copyBuilder();
        TokenRelation.Builder toRelCopy = toTreasuryRel.copyBuilder();
        int newFromPositiveBalancesCount = fromRelBalance > 0L ? fromTreasury.numberPositiveBalances() - 1 : fromTreasury.numberPositiveBalances();
        int newToPositiveBalancesCount = toRelBalance > 0L ? toTreasury.numberPositiveBalances() + 1 : toTreasury.numberPositiveBalances();
        accountStore.put(fromTreasuryCopy.numberPositiveBalances(newFromPositiveBalancesCount).numberOwnedNfts(fromNftsOwned - fromRelBalance).build());
        accountStore.put(toTreasuryCopy.numberPositiveBalances(newToPositiveBalancesCount).numberOwnedNfts(toNftsOwned + fromRelBalance).build());
        tokenRelStore.put(fromRelCopy.balance(0L).build());
        tokenRelStore.put(toRelCopy.balance(toRelBalance + fromRelBalance).build());
    }

    private void validateFrozenAndKey(TokenRelation tokenRel) {
        HandleException.validateTrue((!tokenRel.frozen() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN);
        HandleException.validateTrue((boolean)tokenRel.kycGranted(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_KYC_KEY);
    }

    private Token.Builder customizeToken(@NonNull Token token, @NonNull ExpiryMeta resolvedExpiry, @NonNull TokenUpdateTransactionBody op, boolean isHapiCall) {
        Token.Builder copyToken = token.copyBuilder();
        this.updateKeys(op, token, copyToken);
        this.updateExpiryFields(op, resolvedExpiry, copyToken);
        this.updateTokenAttributes(op, copyToken, token, isHapiCall);
        return copyToken;
    }

    private void updateTokenAttributes(TokenUpdateTransactionBody op, Token.Builder builder, Token originalToken, boolean isHapiCall) {
        String memo;
        if (!op.symbol().isEmpty()) {
            builder.symbol(op.symbol());
        }
        if (!op.name().isEmpty()) {
            builder.name(op.name());
        }
        if (op.hasMemo() && (!(memo = op.memoOrThrow()).isBlank() || isHapiCall)) {
            builder.memo(memo);
        }
        if (op.hasMetadata()) {
            builder.metadata(op.metadataOrThrow());
        }
        if (op.hasTreasury() && this.isHapiCallOrNonZeroTreasuryAccount(isHapiCall, op) && !op.treasuryOrThrow().equals((Object)originalToken.treasuryAccountId())) {
            builder.treasuryAccountId(op.treasuryOrThrow());
        }
    }

    private void updateExpiryFields(TokenUpdateTransactionBody op, ExpiryMeta resolvedExpiry, Token.Builder builder) {
        if (op.hasExpiry()) {
            builder.expirationSecond(resolvedExpiry.expiry());
        }
        if (op.hasAutoRenewPeriod()) {
            builder.autoRenewSeconds(resolvedExpiry.autoRenewPeriod());
        }
        if (op.hasAutoRenewAccount()) {
            builder.autoRenewAccountId(resolvedExpiry.autoRenewAccountId());
        }
    }

    private void updateKeys(TokenUpdateTransactionBody op, Token originalToken, Token.Builder builder) {
        TOKEN_KEYS.forEach(key -> key.updateKey(op, originalToken, builder));
    }

    private void addRequiredSigners(@NonNull PreHandleContext context, @NonNull TokenUpdateTransactionBody op, @NonNull Token token) throws PreCheckException {
        if (op.hasMetadata()) {
            if (token.hasMetadataKey()) {
                this.requireAdminOrRole(context, token, TokenKey.METADATA_KEY);
            } else {
                this.requireAdmin(context, token);
            }
        }
        if (op.hasTreasury() && this.isHapiCallOrNonZeroTreasuryAccount(context.body().hasTransactionID(), op)) {
            this.requireAdmin(context, token);
            context.requireKeyOrThrow(op.treasuryOrThrow(), ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (op.hasAutoRenewAccount()) {
            this.requireAdmin(context, token);
            context.requireKeyOrThrow(op.autoRenewAccountOrThrow(), ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
        if (op.hasAdminKey()) {
            this.requireAdmin(context, token);
            context.requireKey(op.adminKeyOrThrow());
        }
        if (this.containsKeyRemoval(op)) {
            this.requireAdmin(context, token);
        }
        if (TokenUpdateHandler.updatesAdminOnlyNonKeyTokenProperty(op)) {
            this.requireAdmin(context, token);
        }
        for (TokenKey tokenKey : NON_ADMIN_TOKEN_KEYS) {
            Key newRoleKey;
            if (!tokenKey.isPresentInUpdate(op) || AttributeValidator.isKeyRemoval((Key)(newRoleKey = tokenKey.getFromUpdate(op)))) continue;
            if (op.keyVerificationMode() == TokenKeyValidation.NO_VALIDATION) {
                this.requireAdminOrRole(context, token, tokenKey);
                continue;
            }
            Key key = tokenKey.getFromUpdate(op);
            this.requireAdminOrRole(context, token, tokenKey, key);
        }
    }

    private void requireAdminOrRole(@NonNull PreHandleContext context, @NonNull Token token, @NonNull TokenKey roleKey) throws PreCheckException {
        this.requireAdminOrRole(context, token, roleKey, null);
    }

    private void requireAdminOrRole(@NonNull PreHandleContext context, @NonNull Token token, @NonNull TokenKey roleKey, @Nullable Key replacementKey) throws PreCheckException {
        Key maybeRoleKey = roleKey.getFromToken(token);
        Validations.mustExist((Object)maybeRoleKey, (ResponseCodeEnum)(token.hasAdminKey() ? roleKey.tokenHasNoKeyStatus() : ResponseCodeEnum.TOKEN_IS_IMMUTABLE));
        if (token.hasAdminKey()) {
            context.requireKey(TokenUpdateHandler.oneOf(replacementKey == null ? maybeRoleKey : this.allOf(maybeRoleKey, replacementKey), token.adminKeyOrThrow()));
        } else {
            context.requireKey(maybeRoleKey);
            if (replacementKey != null) {
                context.requireKey(replacementKey);
            }
        }
    }

    private void requireAdmin(@NonNull PreHandleContext context, @NonNull Token originalToken) throws PreCheckException {
        PreCheckException.validateTruePreCheck((boolean)originalToken.hasAdminKey(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_IS_IMMUTABLE);
        context.requireKey(originalToken.adminKeyOrThrow());
    }

    private boolean containsKeyRemoval(@NonNull TokenUpdateTransactionBody op) {
        for (TokenKey tokenKey : TOKEN_KEYS) {
            if (!tokenKey.containsKeyRemoval(op)) continue;
            return true;
        }
        return false;
    }

    public static Key oneOf(Key ... keysRequired) {
        return Key.newBuilder().thresholdKey(ThresholdKey.newBuilder().keys(new KeyList(Arrays.asList(keysRequired))).threshold(1).build()).build();
    }

    private Key allOf(Key ... keysRequired) {
        return Key.newBuilder().keyList(new KeyList(Arrays.asList(keysRequired))).build();
    }

    private void updateTreasuryTitles(@NonNull Account existingTreasuryAccount, @NonNull Account newTreasuryAccount, @NonNull Token originalToken, @NonNull WritableAccountStore accountStore, @NonNull WritableTokenRelationStore tokenRelStore) {
        TokenRelation newTokenRelation = tokenRelStore.get(newTreasuryAccount.accountId(), originalToken.tokenId());
        TokenRelation.Builder newRelCopy = newTokenRelation.copyBuilder();
        if (originalToken.hasFreezeKey()) {
            newRelCopy.frozen(false);
        }
        if (originalToken.hasKycKey()) {
            newRelCopy.kycGranted(true);
        }
        int existingTreasuryTitles = existingTreasuryAccount.numberTreasuryTitles();
        int newTreasuryAccountTitles = newTreasuryAccount.numberTreasuryTitles();
        Account.Builder copyOldTreasury = existingTreasuryAccount.copyBuilder().numberTreasuryTitles(existingTreasuryTitles - 1);
        Account.Builder copyNewTreasury = newTreasuryAccount.copyBuilder().numberTreasuryTitles(newTreasuryAccountTitles + 1);
        accountStore.put(copyOldTreasury.build());
        accountStore.put(copyNewTreasury.build());
        tokenRelStore.put(newRelCopy.build());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        TokenUpdateTransactionBody op = body.tokenUpdateOrThrow();
        ReadableTokenStore readableStore = (ReadableTokenStore)feeContext.readableStore(ReadableTokenStore.class);
        Token token = readableStore.get(op.tokenOrThrow());
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)body), (SigValueObj)sigValueObj, token));
    }

    private boolean isHapiCallOrNonZeroTreasuryAccount(boolean isHapiCall, TokenUpdateTransactionBody op) {
        return isHapiCall || !this.isZeroAccount(op.treasuryOrElse(AccountID.DEFAULT));
    }

    private boolean isZeroAccount(@NonNull AccountID accountID) {
        return accountID.equals((Object)ZERO_ACCOUNT_ID);
    }

    private FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj svo, Token token) {
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        if (token != null) {
            TokenUpdateUsage estimate = TokenUpdateUsage.newEstimate((com.hederahashgraph.api.proto.java.TransactionBody)txn, (TxnUsageEstimator)CryptoOpsUsage.txnEstimateFactory.get(sigUsage, txn, (EstimatorUtils)SingletonEstimatorUtils.ESTIMATOR_UTILS)).givenCurrentAdminKey(token.hasAdminKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.adminKeyOrThrow())) : Optional.empty()).givenCurrentFreezeKey(token.hasFreezeKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.freezeKeyOrThrow())) : Optional.empty()).givenCurrentWipeKey(token.hasWipeKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.wipeKeyOrThrow())) : Optional.empty()).givenCurrentSupplyKey(token.hasSupplyKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.supplyKeyOrThrow())) : Optional.empty()).givenCurrentKycKey(token.hasKycKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.kycKeyOrThrow())) : Optional.empty()).givenCurrentPauseKey(token.hasPauseKey() ? Optional.of(CommonPbjConverters.fromPbj((Key)token.pauseKeyOrThrow())) : Optional.empty()).givenCurrentName(token.name()).givenCurrentMemo(token.memo()).givenCurrentSymbol(token.symbol()).givenCurrentExpiry(token.expirationSecond());
            if (token.hasAutoRenewAccountId()) {
                estimate.givenCurrentlyUsingAutoRenewAccount();
            }
            return estimate.get();
        }
        return Fees.CONSTANT_FEE_DATA;
    }
}

