/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.util;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TokenRelListCalculator {
    private static final Logger log = LogManager.getLogger(TokenRelListCalculator.class);
    private final ReadableTokenRelationStore tokenRelStore;

    public TokenRelListCalculator(@NonNull ReadableTokenRelationStore tokenRelStore) {
        this.tokenRelStore = Objects.requireNonNull(tokenRelStore);
    }

    @NonNull
    public TokenRelsRemovalResult removeTokenRels(@NonNull Account account, @NonNull List<TokenRelation> tokenRelsToDelete) {
        if (tokenRelsToDelete.stream().anyMatch(tokenRel -> tokenRel != null && !tokenRel.accountId().equals((Object)account.accountId()))) {
            throw new IllegalArgumentException("All token relations must be for the same account");
        }
        List<TokenRelation> cleanedTokenRelsToDelete = this.filterNullsAndDuplicates(tokenRelsToDelete);
        TokenID currentHeadTokenId = account.headTokenId();
        AccountID accountId = account.accountId();
        Map<TokenID, TokenRelation> tokenRelsToDeleteByTokenId = cleanedTokenRelsToDelete.stream().collect(Collectors.toMap(TokenRelation::tokenId, tokenRel -> tokenRel));
        HashMap<TokenID, TokenRelation> updatedTokenRels = new HashMap<TokenID, TokenRelation>();
        for (TokenRelation currentTokenRelToDelete : cleanedTokenRelsToDelete) {
            TokenRelation updatedNextTokenRel;
            TokenRelation currentNextTokenRel;
            TokenRelation currentTokenRel = Objects.requireNonNull(this.getInPriorityOrder(updatedTokenRels, tokenRelsToDeleteByTokenId, accountId, currentTokenRelToDelete.tokenId()));
            TokenRelation currentPrevTokenRel = this.getInPriorityOrder(updatedTokenRels, tokenRelsToDeleteByTokenId, accountId, currentTokenRel.previousToken());
            TokenRelPointerUpdateResult updatedTokenRelsSurroundingCurrentTokenRel = this.updatePointersSurroundingTargetTokenRel(currentPrevTokenRel, currentNextTokenRel = this.getInPriorityOrder(updatedTokenRels, tokenRelsToDeleteByTokenId, accountId, currentTokenRel.nextToken()));
            TokenRelation updatedPrevTokenRel = updatedTokenRelsSurroundingCurrentTokenRel.updatedPrevTokenRel();
            if (updatedPrevTokenRel != null) {
                updatedTokenRels.put(updatedPrevTokenRel.tokenId(), updatedPrevTokenRel);
            }
            if ((updatedNextTokenRel = updatedTokenRelsSurroundingCurrentTokenRel.updatedNextTokenRel()) == null) continue;
            updatedTokenRels.put(updatedNextTokenRel.tokenId(), updatedNextTokenRel);
        }
        List<TokenRelation> updatedTokenRelsToKeep = updatedTokenRels.values().stream().filter(tokenRel -> !tokenRelsToDeleteByTokenId.containsKey(tokenRel.tokenId())).toList();
        TokenID updatedHeadTokenId = this.calculateHeadTokenAfterDeletions(currentHeadTokenId, account, updatedTokenRels, tokenRelsToDeleteByTokenId);
        return new TokenRelsRemovalResult(updatedHeadTokenId, updatedTokenRelsToKeep);
    }

    @NonNull
    private List<TokenRelation> filterNullsAndDuplicates(List<TokenRelation> tokenRelsToDelete) {
        ArrayList<TokenRelation> cleaned = new ArrayList<TokenRelation>(tokenRelsToDelete.size());
        for (TokenRelation tokenRel : tokenRelsToDelete) {
            if (tokenRel == null || cleaned.contains(tokenRel)) continue;
            cleaned.add(tokenRel);
        }
        return cleaned;
    }

    @Nullable
    private TokenRelation getInPriorityOrder(@NonNull Map<TokenID, TokenRelation> updatedTokenRels, @NonNull Map<TokenID, TokenRelation> tokenRelsToDeleteByTokenId, @NonNull AccountID accountId, TokenID tokenIdToLookup) {
        if (tokenIdToLookup == null) {
            return null;
        }
        TokenRelation updatedTokenRelsValue = updatedTokenRels.get(tokenIdToLookup);
        if (updatedTokenRelsValue != null) {
            return updatedTokenRelsValue;
        }
        TokenRelation tokensToDeleteRelsValue = tokenRelsToDeleteByTokenId.get(tokenIdToLookup);
        if (tokensToDeleteRelsValue != null) {
            return tokensToDeleteRelsValue;
        }
        return this.tokenRelStore.get(accountId, tokenIdToLookup);
    }

    @NonNull
    private TokenRelPointerUpdateResult updatePointersSurroundingTargetTokenRel(@Nullable TokenRelation prevTokenRel, @Nullable TokenRelation nextTokenRel) {
        TokenID prevTokenRelTokenId = prevTokenRel != null ? prevTokenRel.tokenId() : null;
        TokenID nextTokenRelTokenId = nextTokenRel != null ? nextTokenRel.tokenId() : null;
        TokenRelation newPrevTokenRel = prevTokenRel != null ? prevTokenRel.copyBuilder().nextToken(nextTokenRelTokenId).build() : null;
        TokenRelation newNextTokenRel = nextTokenRel != null ? nextTokenRel.copyBuilder().previousToken(prevTokenRelTokenId).build() : null;
        return new TokenRelPointerUpdateResult(newPrevTokenRel, newNextTokenRel);
    }

    private TokenID calculateHeadTokenAfterDeletions(TokenID currentHeadTokenId, @NonNull Account account, @NonNull Map<TokenID, TokenRelation> updatedTokenRels, @NonNull Map<TokenID, TokenRelation> tokenRelsToDeleteByTokenId) {
        TokenRelation currentWalkedTokenRel;
        AccountID accountId = account.accountId();
        if (currentHeadTokenId == null) {
            return null;
        }
        TokenID currentTokenId = currentHeadTokenId;
        int safetyCounter = 0;
        do {
            TokenRelation tokenRelation = currentWalkedTokenRel = updatedTokenRels.containsKey(currentTokenId) ? updatedTokenRels.get(currentTokenId) : this.tokenRelStore.get(accountId, currentTokenId);
            if (currentWalkedTokenRel != null) {
                if (!tokenRelsToDeleteByTokenId.containsKey(currentWalkedTokenRel.tokenId())) break;
                currentTokenId = currentWalkedTokenRel.nextToken();
            } else {
                currentTokenId = null;
            }
            if (safetyCounter++ <= account.numberAssociations()) continue;
            log.error("Encountered token rels list that exceeds total token associations for account {}.{}.{}", (Object)account.accountId().shardNum(), (Object)account.accountId().realmNum(), (Object)account.accountId().accountNum());
            return null;
        } while (currentWalkedTokenRel != null && currentTokenId != null);
        return currentTokenId != null && currentTokenId.tokenNum() > 0L ? currentTokenId : null;
    }

    private record TokenRelPointerUpdateResult(@Nullable TokenRelation updatedPrevTokenRel, @Nullable TokenRelation updatedNextTokenRel) {
    }

    public record TokenRelsRemovalResult(@Nullable TokenID updatedHeadTokenId, @NonNull List<TokenRelation> updatedTokenRelsStillInChain) {
    }
}

