/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.esaulpaugh.headlong.abi.Address;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SyntheticIds {
    private static final Address ZERO_ADDRESS = Address.wrap((String)"0x0000000000000000000000000000000000000000");
    private static final AccountID DEBIT_NON_CANONICAL_REFERENCE_ID = AccountID.newBuilder().accountNum(0L).build();
    private static final AccountID CREDIT_NON_CANONICAL_REFERENCE_ID = AccountID.newBuilder().alias(Bytes.wrap((byte[])new byte[20])).build();

    @Inject
    public SyntheticIds() {
    }

    public AddressIdConverter converterFor(final @NonNull HederaNativeOperations nativeOperations) {
        return new AddressIdConverter(){

            @Override
            @NonNull
            public AccountID convert(@NonNull Address address) {
                return SyntheticIds.syntheticIdFor(address, nativeOperations);
            }

            @Override
            @NonNull
            public AccountID convertCredit(@NonNull Address address) {
                return SyntheticIds.syntheticIdForCredit(address, nativeOperations);
            }
        };
    }

    @NonNull
    private static AccountID syntheticIdFor(@NonNull Address address, @NonNull HederaNativeOperations nativeOperations) {
        return SyntheticIds.internalSyntheticId(false, address, nativeOperations);
    }

    @NonNull
    private static AccountID syntheticIdForCredit(@NonNull Address address, @NonNull HederaNativeOperations nativeOperations) {
        return SyntheticIds.internalSyntheticId(true, address, nativeOperations);
    }

    @NonNull
    private static AccountID internalSyntheticId(boolean isCredit, @NonNull Address address, @NonNull HederaNativeOperations nativeOperations) {
        Objects.requireNonNull(address);
        long accountNum = ConversionUtils.accountNumberForEvmReference(address, nativeOperations);
        if (accountNum == -1L) {
            byte[] explicit = ConversionUtils.explicitFromHeadlong(address);
            if (address.equals((Object)ZERO_ADDRESS)) {
                return isCredit ? nativeOperations.entityIdFactory().newAccountIdWithAlias(Bytes.wrap((byte[])explicit)) : AccountID.newBuilder().accountNum(0L).build();
            }
            if (ConversionUtils.isLongZero(address)) {
                return isCredit ? nativeOperations.entityIdFactory().newAccountIdWithAlias(Bytes.wrap((byte[])explicit)) : nativeOperations.entityIdFactory().newAccountId(ConversionUtils.numberOfLongZero(explicit));
            }
            return nativeOperations.entityIdFactory().newAccountIdWithAlias(Bytes.wrap((byte[])explicit));
        }
        if (accountNum == -2L) {
            return isCredit ? CREDIT_NON_CANONICAL_REFERENCE_ID : DEBIT_NON_CANONICAL_REFERENCE_ID;
        }
        return nativeOperations.entityIdFactory().newAccountId(accountNum);
    }
}

