/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.ConfigException;
import io.helidon.config.ListNodeBuilderImpl;
import io.helidon.config.ListNodeImpl;
import io.helidon.config.MergeableNode;
import io.helidon.config.ObjectNodeBuilderImpl;
import io.helidon.config.ObjectNodeImpl;
import io.helidon.config.ValueNodeImpl;
import io.helidon.config.spi.ConfigNode;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public abstract class AbstractNodeBuilderImpl<ID, B> {
    private final B thisBuilder;
    private final Function<String, String> tokenResolver;

    AbstractNodeBuilderImpl(Function<String, String> tokenResolver) {
        this.tokenResolver = tokenResolver;
        this.thisBuilder = this;
    }

    static MergeableNode wrap(ConfigNode node) {
        return AbstractNodeBuilderImpl.wrap(node, Function.identity());
    }

    static MergeableNode wrap(ConfigNode node, Function<String, String> resolveTokenFunction) {
        switch (node.nodeType()) {
            case OBJECT: {
                return ObjectNodeImpl.wrap((ConfigNode.ObjectNode)node, resolveTokenFunction);
            }
            case LIST: {
                return ListNodeImpl.wrap((ConfigNode.ListNode)node, resolveTokenFunction);
            }
            case VALUE: {
                return ValueNodeImpl.wrap((ConfigNode.ValueNode)node);
            }
        }
        throw new IllegalArgumentException("Unsupported node type: " + node.getClass().getName());
    }

    static String formatFrom(String from) {
        if (from != null) {
            return " from " + from;
        }
        return "";
    }

    protected abstract ID id(MergingKey var1);

    protected abstract MergeableNode member(ID var1);

    protected abstract void update(ID var1, MergeableNode var2);

    protected abstract void merge(ID var1, MergeableNode var2);

    protected B deepMerge(MergingKey key, MergeableNode node) {
        ID id = this.id(key);
        if (key.isLeaf()) {
            this.merge(id, node);
        } else {
            MergeableNode member = this.member(id);
            switch (member.nodeType()) {
                case OBJECT: {
                    this.mergeObjectMember((ConfigNode.ObjectNode)((Object)member), key, node, id);
                    break;
                }
                case LIST: {
                    this.mergeListMember((ConfigNode.ListNode)((Object)member), key, node, id);
                    break;
                }
                case VALUE: {
                    this.mergeValueMember((ConfigNode.ValueNode)((Object)member), key, node, id);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported node type: " + member.getClass().getName());
                }
            }
        }
        return this.thisBuilder;
    }

    private void mergeValueMember(ConfigNode.ValueNode member, MergingKey key, MergeableNode node, ID id) {
        ObjectNodeImpl on = ObjectNodeBuilderImpl.create(Map.of(), this.tokenResolver).value(member.value()).build();
        ConfigNode.ObjectNode merged = ((ConfigNode.ObjectNode.Builder)ObjectNodeBuilderImpl.create(on, this.tokenResolver).value(on.value()).deepMerge(key.rest(), node)).build();
        this.update(id, AbstractNodeBuilderImpl.wrap(merged, this.tokenResolver));
    }

    private void mergeListMember(ConfigNode.ListNode member, MergingKey key, MergeableNode node, ID id) {
        try {
            ConfigNode merged = (ConfigNode)((ConfigNode.ListNode.Builder)ListNodeBuilderImpl.from(member, this.tokenResolver).value(member.value()).deepMerge(key.rest(), node)).build();
            this.update(id, AbstractNodeBuilderImpl.wrap(merged, this.tokenResolver));
        }
        catch (ConfigException ex) {
            throw new ConfigException(String.valueOf(id) + ": " + ex.getLocalizedMessage(), (Throwable)((Object)ex));
        }
    }

    private void mergeObjectMember(ConfigNode.ObjectNode member, MergingKey key, MergeableNode node, ID id) {
        try {
            ConfigNode.ObjectNode merged = ((ConfigNode.ObjectNode.Builder)ObjectNodeBuilderImpl.create(member, this.tokenResolver).value(member.value()).deepMerge(key.rest(), node)).build();
            this.update(id, AbstractNodeBuilderImpl.wrap(merged, this.tokenResolver));
        }
        catch (ConfigException ex) {
            throw new ConfigException(String.valueOf(id) + ": " + ex.getLocalizedMessage(), (Throwable)((Object)ex));
        }
    }

    Function<String, String> tokenResolver() {
        return this.tokenResolver;
    }

    public static class MergingKey {
        private final String first;
        private final MergingKey rest;

        private MergingKey(String first, MergingKey rest) {
            Objects.requireNonNull(first, "first cannot be null");
            this.first = first;
            this.rest = rest;
        }

        public static MergingKey of(String key) {
            Objects.requireNonNull(key, "key cannot be null");
            int index = key.indexOf(46);
            if (index == -1) {
                return new MergingKey(key, null);
            }
            return new MergingKey(key.substring(0, index), MergingKey.of(key.substring(index + 1)));
        }

        public String first() {
            return this.first;
        }

        public MergingKey rest() {
            return this.rest;
        }

        public boolean isLeaf() {
            return this.rest == null;
        }

        public String toString() {
            return this.first + (String)(this.rest != null ? "." + String.valueOf(this.rest) : "");
        }
    }
}

