/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.media.type.spi.MediaTypeDetector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

class CustomDetector
implements MediaTypeDetector {
    private static final String MEDIA_TYPE_RESOURCE = "META-INF/helidon/media-types.properties";
    private static final System.Logger LOGGER = System.getLogger(CustomDetector.class.getName());
    private static final Map<String, MediaType> MAPPINGS = new HashMap<String, MediaType>();

    CustomDetector() {
    }

    @Override
    public Optional<MediaType> detectExtensionType(String fileSuffix) {
        return Optional.ofNullable(MAPPINGS.get(fileSuffix));
    }

    static {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(MEDIA_TYPE_RESOURCE);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "Loading custom media type mapping from: " + String.valueOf(url));
                }
                InputStream is = url.openStream();
                try {
                    Properties properties = new Properties();
                    properties.load(is);
                    for (String name : properties.stringPropertyNames()) {
                        MAPPINGS.put(name, MediaTypes.create(properties.getProperty(name)));
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Failed to load custom media types mapping", (Throwable)e);
        }
    }
}

