/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public enum NoopFeeCharging implements FeeCharging
{
    NOOP_FEE_CHARGING;


    @Override
    public FeeCharging.Validation validate(@NonNull Account payer, @NonNull AccountID creatorId, @NonNull Fees fees, @NonNull TransactionBody body, boolean isDuplicate, @NonNull HederaFunctionality function, @NonNull HandleContext.TransactionCategory category) {
        Objects.requireNonNull(payer);
        Objects.requireNonNull(creatorId);
        Objects.requireNonNull(fees);
        Objects.requireNonNull(body);
        Objects.requireNonNull(function);
        Objects.requireNonNull(category);
        return PassedValidation.INSTANCE;
    }

    @Override
    public Fees charge(@NonNull FeeCharging.Context ctx, @NonNull FeeCharging.Validation validation, @NonNull Fees fees) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(validation);
        Objects.requireNonNull(fees);
        return Fees.FREE;
    }

    @Override
    public void refund(@NonNull FeeCharging.Context ctx, @NonNull Fees fees) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(fees);
    }

    private record PassedValidation(boolean creatorDidDueDiligence, @Nullable ResponseCodeEnum maybeErrorStatus) implements FeeCharging.Validation
    {
        private static final PassedValidation INSTANCE = new PassedValidation(true, null);
    }
}

