/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.config.api.source.ConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class SimpleConfigSource
implements ConfigSource {
    private final Map<String, String> internalProperties;
    private final Map<String, List<String>> internalListProperties;
    private int ordinal = 10;

    public SimpleConfigSource() {
        this.internalProperties = new HashMap<String, String>();
        this.internalListProperties = new HashMap<String, List<String>>();
    }

    public SimpleConfigSource(@NonNull Map<String, String> properties) {
        this(properties, new HashMap<String, List<String>>());
    }

    public SimpleConfigSource(@NonNull Map<String, String> properties, @NonNull Map<String, List<String>> listProperties) {
        this.internalProperties = new HashMap<String, String>(Objects.requireNonNull(properties));
        this.internalListProperties = new HashMap<String, List<String>>(Objects.requireNonNull(listProperties));
    }

    public SimpleConfigSource(String propertyName, String value) {
        this();
        this.withValue(propertyName, value);
    }

    public SimpleConfigSource(String propertyName, List<?> value) {
        this();
        this.setValues(propertyName, value, Object::toString);
    }

    public SimpleConfigSource(String propertyName, Integer value) {
        this();
        this.withValue(propertyName, value);
    }

    public SimpleConfigSource(String propertyName, Long value) {
        this();
        this.withValue(propertyName, value);
    }

    public SimpleConfigSource(String propertyName, Double value) {
        this();
        this.withValue(propertyName, value);
    }

    public SimpleConfigSource(String propertyName, Float value) {
        this();
        this.withValue(propertyName, value);
    }

    public SimpleConfigSource(String propertyName, Boolean value) {
        this();
        this.withValue(propertyName, value);
    }

    public SimpleConfigSource withValue(String propertyName, String value) {
        this.setValue(propertyName, value, v -> v);
        return this;
    }

    public SimpleConfigSource withValue(String propertyName, Integer value) {
        this.setValue(propertyName, value, v -> Integer.toString(v));
        return this;
    }

    public SimpleConfigSource withValue(String propertyName, Double value) {
        this.setValue(propertyName, value, v -> Double.toString(v));
        return this;
    }

    public SimpleConfigSource withValue(String propertyName, Float value) {
        this.setValue(propertyName, value, v -> Float.toString(v.floatValue()));
        return this;
    }

    public SimpleConfigSource withValue(String propertyName, Long value) {
        this.setValue(propertyName, value, v -> Long.toString(v));
        return this;
    }

    @NonNull
    public SimpleConfigSource withValue(@NonNull String propertyName, @NonNull Boolean value) {
        this.setValue(propertyName, value, v -> Boolean.toString(v));
        return this;
    }

    private <T> void setValue(@NonNull String propertyName, @Nullable T value, @NonNull Function<T, String> converter) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(converter, "converter must not be null");
        this.internalProperties.put(propertyName, Optional.ofNullable(value).map(converter::apply).orElse(null));
    }

    public SimpleConfigSource withBooleanValues(String propertyName, List<Boolean> values) {
        this.setValues(propertyName, values, v -> Boolean.toString(v));
        return this;
    }

    public SimpleConfigSource withIntegerValues(String propertyName, List<Integer> values) {
        this.setValues(propertyName, values, v -> Integer.toString(v));
        return this;
    }

    public SimpleConfigSource withLongValues(String propertyName, List<Long> values) {
        this.setValues(propertyName, values, v -> Long.toString(v));
        return this;
    }

    public SimpleConfigSource withDoubleValues(String propertyName, List<Double> values) {
        this.setValues(propertyName, values, v -> Double.toString(v));
        return this;
    }

    public SimpleConfigSource withStringValues(String propertyName, List<String> values) {
        this.setValues(propertyName, values, v -> v);
        return this;
    }

    private <T> void setValues(@NonNull String propertyName, @Nullable List<T> values, @NonNull Function<T, String> converter) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        Objects.requireNonNull(converter, "converter must not be null");
        if (values == null) {
            this.internalListProperties.put(propertyName, null);
        } else if (values.isEmpty()) {
            this.internalListProperties.put(propertyName, List.of());
        } else {
            List<String> rawValues = values.stream().map(converter).toList();
            this.internalListProperties.put(propertyName, rawValues);
        }
    }

    public SimpleConfigSource withOrdinal(int ordinal) {
        this.ordinal = ordinal;
        return this;
    }

    public void reset() {
        this.internalProperties.clear();
    }

    @NonNull
    public Set<String> getPropertyNames() {
        return Stream.concat(this.internalProperties.keySet().stream(), this.internalListProperties.keySet().stream()).collect(Collectors.toSet());
    }

    @Nullable
    public String getValue(@NonNull String propertyName) throws NoSuchElementException {
        if (this.internalProperties.containsKey(propertyName)) {
            return this.internalProperties.get(propertyName);
        }
        throw new NoSuchElementException("Property " + propertyName + " not found");
    }

    public boolean isListProperty(@NonNull String propertyName) throws NoSuchElementException {
        return this.internalListProperties.containsKey(propertyName);
    }

    @NonNull
    public List<String> getListValue(@NonNull String propertyName) throws NoSuchElementException {
        if (this.internalListProperties.containsKey(propertyName)) {
            return this.internalListProperties.get(propertyName);
        }
        throw new NoSuchElementException("Property " + propertyName + " not found");
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

