/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.datasource;

import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import java.io.IOException;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public record VirtualHashRecord(long path, Hash hash) {
    public static final FieldDefinition FIELD_HASHRECORD_PATH = new FieldDefinition("path", FieldType.FIXED64, false, true, false, 1);
    public static final FieldDefinition FIELD_HASHRECORD_HASH = new FieldDefinition("hash", FieldType.BYTES, false, true, false, 2);

    public VirtualHashRecord(long path) {
        this(path, null);
    }

    public static VirtualHashRecord parseFrom(ReadableSequentialData in) {
        if (in == null) {
            return null;
        }
        long path = 0L;
        byte[] hashBytes = null;
        while (in.hasRemaining()) {
            int field = in.readVarInt(false);
            int tag = field >> 3;
            if (tag == FIELD_HASHRECORD_PATH.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_FIXED_64_BIT.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                path = in.readLong();
                continue;
            }
            if (tag == FIELD_HASHRECORD_HASH.number()) {
                if ((field & 7) != ProtoConstants.WIRE_TYPE_DELIMITED.ordinal()) {
                    throw new IllegalArgumentException("Wrong field type: " + field);
                }
                int len = in.readVarInt(false);
                hashBytes = new byte[len];
                if (in.readBytes(hashBytes) == (long)len) continue;
                throw new IllegalArgumentException("Failed to read hash bytes");
            }
            throw new IllegalArgumentException("Unknown field: " + field);
        }
        if (hashBytes == null) {
            throw new IllegalArgumentException("Null hash bytes");
        }
        return new VirtualHashRecord(path, new Hash(hashBytes));
    }

    public int getSizeInBytes() {
        int size = 0;
        size += ProtoWriterTools.sizeOfTag((FieldDefinition)FIELD_HASHRECORD_PATH);
        size += 8;
        if (this.hash != null) {
            Bytes hashBytes = this.hash.getBytes();
            size += ProtoWriterTools.sizeOfDelimited((FieldDefinition)FIELD_HASHRECORD_HASH, (int)Math.toIntExact(hashBytes.length()));
        }
        return size;
    }

    public void writeTo(WritableSequentialData out) {
        ProtoWriterTools.writeTag((WritableSequentialData)out, (FieldDefinition)FIELD_HASHRECORD_PATH);
        out.writeLong(this.path);
        if (this.hash != null) {
            Bytes hashBytes = this.hash.getBytes();
            ProtoWriterTools.writeDelimited((WritableSequentialData)out, (FieldDefinition)FIELD_HASHRECORD_HASH, (int)Math.toIntExact(hashBytes.length()), arg_0 -> ((Bytes)hashBytes).writeTo(arg_0));
        }
    }

    public static void extractAndWriteHashBytes(ReadableSequentialData in, SerializableDataOutputStream out) throws IOException {
        out.writeInt(DigestType.SHA_384.id());
        while (in.hasRemaining()) {
            int tag = in.readVarInt(false);
            int fieldNum = tag >> 3;
            if (fieldNum == FIELD_HASHRECORD_PATH.number()) {
                in.skip(8L);
                continue;
            }
            if (fieldNum == FIELD_HASHRECORD_HASH.number()) {
                int hashSize = in.readVarInt(false);
                byte[] arr = new byte[hashSize];
                in.readBytes(arr);
                out.writeInt(hashSize);
                out.write(arr);
                break;
            }
            throw new IllegalArgumentException("Unknown virtual hash record field: " + fieldNum);
        }
    }
}

