/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.impl.PartialMerkleLeaf;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.merkle.VirtualNode;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

@ConstructableIgnored
public final class VirtualLeafNode
extends PartialMerkleLeaf
implements MerkleLeaf,
VirtualNode {
    public static final long CLASS_ID = 5302557153892697290L;
    private final VirtualLeafBytes virtualRecord;

    public VirtualLeafNode(VirtualLeafBytes virtualLeafBytes, Hash hash) {
        this.virtualRecord = Objects.requireNonNull(virtualLeafBytes);
        this.setHash(hash);
    }

    @Override
    public long getPath() {
        return this.virtualRecord.path();
    }

    public Bytes getKey() {
        return this.virtualRecord.keyBytes();
    }

    public Bytes getValue() {
        return this.virtualRecord.valueBytes();
    }

    public <V> V getValue(Codec<V> valueCodec) {
        return this.virtualRecord.value(valueCodec);
    }

    public VirtualLeafNode copy() {
        throw new UnsupportedOperationException("Don't use this");
    }

    public long getClassId() {
        return 5302557153892697290L;
    }

    public int getVersion() {
        return 1;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.virtualRecord).toString();
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VirtualLeafNode that = (VirtualLeafNode)o;
        return this.virtualRecord.equals(that.virtualRecord);
    }

    public int hashCode() {
        return this.virtualRecord.hashCode();
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

