/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm;

import java.util.Comparator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EvmSpecVersion {
    FRONTIER(0, true, "Frontier", "Finalized"),
    HOMESTEAD(0, true, "Homestead", "Finalized"),
    TANGERINE_WHISTLE(0, true, "Tangerine Whistle", "Finalized"),
    SPURIOUS_DRAGON(0, true, "Spuruous Dragon", "Finalized"),
    BYZANTIUM(0, true, "Byzantium", "Finalized"),
    CONSTANTINOPLE(0, true, "Constantinople", "Did not reach Mainnet"),
    PETERSBURG(0, true, "ConstantinopleFix", "Finalized (also called Petersburg)"),
    ISTANBUL(0, true, "Istanbul", "Finalized"),
    BERLIN(0, true, "Berlin", "Finalized"),
    LONDON(0, true, "London", "Finalized"),
    PARIS(0, true, "Merge", "Finalized (also called Paris)"),
    SHANGHAI(0, true, "Shanghai", "Finalized"),
    CANCUN(0, true, "Cancun", "Finalized"),
    PRAGUE(0, false, "Prague", "In Development"),
    OSAKA(0, false, "Osaka", "Placeholder"),
    BOGOTA(0, false, "Bogota", "Placeholder"),
    FUTURE_EIPS(1, false, "Future_EIPs", "Development, for accepted and unscheduled EIPs"),
    EXPERIMENTAL_EIPS(1, false, "Experimental_EIPs", "Development, for experimental EIPs");

    private static final Logger LOGGER;
    final boolean specFinalized;
    final int maxEofVersion;
    final String name;
    final String description;
    boolean versionWarned = false;

    private EvmSpecVersion(int maxEofVersion, boolean specFinalized, String name, String description) {
        this.maxEofVersion = maxEofVersion;
        this.specFinalized = specFinalized;
        this.name = name;
        this.description = description;
    }

    public static EvmSpecVersion defaultVersion() {
        return SHANGHAI;
    }

    public int getMaxEofVersion() {
        return this.maxEofVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void maybeWarnVersion() {
        if (this.versionWarned) {
            return;
        }
        if (!this.specFinalized) {
            LOGGER.error("****** Not for Production Network Use ******\nExecuting code from EVM Spec Version {}, which has not been finalized.\n****** Not for Production Network Use ******", (Object)this.name());
        }
        this.versionWarned = true;
    }

    public static EvmSpecVersion fromName(String name) {
        for (EvmSpecVersion version : EvmSpecVersion.values()) {
            if (!version.name().equalsIgnoreCase(name)) continue;
            return version;
        }
        return null;
    }

    public static EvmSpecVersion mostRecent() {
        return Stream.of(EvmSpecVersion.values()).filter(v -> v.specFinalized).max(Comparator.naturalOrder()).orElseThrow();
    }

    static {
        LOGGER = LoggerFactory.getLogger(EvmSpecVersion.class);
    }
}

