/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SwapOperation
extends AbstractFixedCostOperation {
    public static final int SWAP_BASE = 143;
    static final Operation.OperationResult swapSuccess = new Operation.OperationResult(3L, null);
    private final int index;
    protected final Operation.OperationResult underflowResponse;

    public SwapOperation(int index, GasCalculator gasCalculator) {
        super(143 + index, "SWAP" + index, index + 1, index + 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
        this.index = index;
        this.underflowResponse = new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return SwapOperation.staticOperation(frame, this.index);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame, int index) {
        Bytes tmp = frame.getStackItem(0);
        frame.setStackItem(0, frame.getStackItem(index));
        frame.setStackItem(index, tmp);
        return swapSuccess;
    }
}

