/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.AccountState;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.worldstate.MutableWorldView;

public interface WorldUpdater
extends MutableWorldView {
    public MutableAccount createAccount(Address var1, long var2, Wei var4);

    default public MutableAccount createAccount(Address address) {
        return this.createAccount(address, 0L, Account.DEFAULT_BALANCE);
    }

    default public MutableAccount getOrCreate(Address address) {
        MutableAccount account = this.getAccount(address);
        return account == null ? this.createAccount(address) : account;
    }

    default public MutableAccount getOrCreateSenderAccount(Address address) {
        return this.getOrCreate(address);
    }

    public MutableAccount getAccount(Address var1);

    default public MutableAccount getSenderAccount(MessageFrame frame) {
        return this.getAccount(frame.getSenderAddress());
    }

    public void deleteAccount(Address var1);

    public Collection<? extends Account> getTouchedAccounts();

    public Collection<Address> getDeletedAccountAddresses();

    public void revert();

    public void commit();

    public Optional<WorldUpdater> parentUpdater();

    default public void clearAccountsThatAreEmpty() {
        new ArrayList<Account>(this.getTouchedAccounts()).stream().filter(AccountState::isEmpty).forEach(a -> this.deleteAccount(a.getAddress()));
    }

    default public void markTransactionBoundary() {
    }
}

