/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime.io;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public class UnsafeUtils {
    private static final Unsafe UNSAFE;
    private static final boolean NEED_CHANGE_BYTE_ORDER;
    private static final int BYTE_ARRAY_BASE_OFFSET;
    private static final long DIRECT_BYTEBUFFER_ADDRESS_OFFSET;

    private UnsafeUtils() {
    }

    public static byte getArrayByte(byte[] arr, int offset) {
        if (arr.length <= offset) {
            throw new IndexOutOfBoundsException();
        }
        return UnsafeUtils.getArrayByteNoChecks(arr, offset);
    }

    public static byte getArrayByteNoChecks(byte[] arr, int offset) {
        return UNSAFE.getByte(arr, BYTE_ARRAY_BASE_OFFSET + offset);
    }

    public static byte getHeapBufferByte(ByteBuffer buf, int offset) {
        if (buf.limit() < offset + 1) {
            throw new BufferUnderflowException();
        }
        return UnsafeUtils.getHeapBufferByteNoChecks(buf, offset);
    }

    public static byte getHeapBufferByteNoChecks(ByteBuffer buf, int offset) {
        return UNSAFE.getByte(buf.array(), BYTE_ARRAY_BASE_OFFSET + offset);
    }

    public static byte getDirectBufferByte(ByteBuffer buf, int offset) {
        if (buf.limit() < offset + 1) {
            throw new BufferUnderflowException();
        }
        return UnsafeUtils.getDirectBufferByteNoChecks(buf, offset);
    }

    public static byte getDirectBufferByteNoChecks(ByteBuffer buf, int offset) {
        long address = UNSAFE.getLong(buf, DIRECT_BYTEBUFFER_ADDRESS_OFFSET);
        return UNSAFE.getByte(null, address + (long)offset);
    }

    public static int getInt(byte[] arr, int offset) {
        if (arr.length < offset + 4) {
            throw new BufferUnderflowException();
        }
        int value = UNSAFE.getInt(arr, BYTE_ARRAY_BASE_OFFSET + offset);
        return NEED_CHANGE_BYTE_ORDER ? Integer.reverseBytes(value) : value;
    }

    public static long getLong(byte[] arr, int offset) {
        if (arr.length < offset + 8) {
            throw new BufferUnderflowException();
        }
        long value = UNSAFE.getLong(arr, BYTE_ARRAY_BASE_OFFSET + offset);
        return NEED_CHANGE_BYTE_ORDER ? Long.reverseBytes(value) : value;
    }

    public static void getHeapBufferToArray(ByteBuffer buffer, long offset, byte[] dst, int dstOffset, int length) {
        UNSAFE.copyMemory(buffer.array(), (long)BYTE_ARRAY_BASE_OFFSET + offset, dst, BYTE_ARRAY_BASE_OFFSET + dstOffset, length);
    }

    public static void getDirectBufferToArray(ByteBuffer buffer, long offset, byte[] dst, int dstOffset, int length) {
        long address = UNSAFE.getLong(buffer, DIRECT_BYTEBUFFER_ADDRESS_OFFSET);
        UNSAFE.copyMemory(null, address + offset, dst, BYTE_ARRAY_BASE_OFFSET + dstOffset, length);
    }

    public static void getDirectBufferToDirectBuffer(ByteBuffer buffer, long offset, ByteBuffer dst, int dstOffset, int length) {
        long address = UNSAFE.getLong(buffer, DIRECT_BYTEBUFFER_ADDRESS_OFFSET);
        long dstAddress = UNSAFE.getLong(dst, DIRECT_BYTEBUFFER_ADDRESS_OFFSET);
        UNSAFE.copyMemory(null, address + offset, null, dstAddress, length);
    }

    public static void putByteArrayToDirectBuffer(ByteBuffer buffer, long offset, byte[] src, int srcOffset, int length) {
        long address = UNSAFE.getLong(buffer, DIRECT_BYTEBUFFER_ADDRESS_OFFSET);
        UNSAFE.copyMemory(src, BYTE_ARRAY_BASE_OFFSET + srcOffset, null, address + offset, length);
    }

    static {
        try {
            Field theUnsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafeField.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafeField.get(null);
            NEED_CHANGE_BYTE_ORDER = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
            BYTE_ARRAY_BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            Field addressField = Buffer.class.getDeclaredField("address");
            DIRECT_BYTEBUFFER_ADDRESS_OFFSET = UNSAFE.objectFieldOffset(addressField);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new InternalError(e);
        }
    }
}

