/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import java.math.BigInteger;
import java.security.spec.ECPoint;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.util.BigIntegers;

public class ECPointUtil {
    public static ECPoint fromBouncyCastleECPoint(org.bouncycastle.math.ec.ECPoint bouncyCastleECPoint) {
        ECFieldElement xCoord = bouncyCastleECPoint.getAffineXCoord();
        ECFieldElement yCoord = bouncyCastleECPoint.getAffineYCoord();
        Bytes32 xEncoded = Bytes32.wrap((byte[])xCoord.getEncoded());
        Bytes32 yEncoded = Bytes32.wrap((byte[])yCoord.getEncoded());
        BigInteger x = xEncoded.toUnsignedBigInteger();
        BigInteger y = yEncoded.toUnsignedBigInteger();
        return new ECPoint(x, y);
    }

    public static Bytes getEncodedBytes(ECPoint ecPoint) {
        Bytes32 xBytes = Bytes32.wrap((byte[])BigIntegers.asUnsignedByteArray((int)32, (BigInteger)ecPoint.getAffineX()));
        Bytes32 yBytes = Bytes32.wrap((byte[])BigIntegers.asUnsignedByteArray((int)32, (BigInteger)ecPoint.getAffineY()));
        return Bytes.concatenate((Bytes[])new Bytes[]{xBytes, yBytes});
    }
}

